
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Adds a JDBC Driver to a resource. The driver module is created only if driverJarName is set (in such a case, the jar file content must be appended to this JSON message). Otherwise, the existence of the module given by moduleName and default slot "main" will be assumed.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "resourcePath",
    "driverName",
    "moduleName",
    "driverJarName"
})
public class AddJdbcDriverRequest
    extends AuthMessage
{

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     */
    @JsonProperty("resourcePath")
    private String resourcePath;
    /**
     * 
     * (Required)
     * 
     */
    @JsonProperty("driverName")
    private String driverName;
    /**
     * The name of the JBoss Module to create or use, such as "org.example.jdbc.driver"
     * (Required)
     * 
     */
    @JsonProperty("moduleName")
    private String moduleName;
    /**
     * The name of the jar file that should be used when storing the binary data to in the module directory on the server. If this field is set the jar bits must be appended to this JSON message. If this field is set, the module will be created, otherwise the existence of the module given by moduleName and default slot "main" will be assumed.
     * 
     */
    @JsonProperty("driverJarName")
    private String driverJarName;

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     * @return
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public String getResourcePath() {
        return resourcePath;
    }

    /**
     * The inventory path to the Application Server resource where the driver should be installed
     * (Required)
     * 
     * @param resourcePath
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * 
     * (Required)
     * 
     * @return
     *     The driverName
     */
    @JsonProperty("driverName")
    public String getDriverName() {
        return driverName;
    }

    /**
     * 
     * (Required)
     * 
     * @param driverName
     *     The driverName
     */
    @JsonProperty("driverName")
    public void setDriverName(String driverName) {
        this.driverName = driverName;
    }

    /**
     * The name of the JBoss Module to create or use, such as "org.example.jdbc.driver"
     * (Required)
     * 
     * @return
     *     The moduleName
     */
    @JsonProperty("moduleName")
    public String getModuleName() {
        return moduleName;
    }

    /**
     * The name of the JBoss Module to create or use, such as "org.example.jdbc.driver"
     * (Required)
     * 
     * @param moduleName
     *     The moduleName
     */
    @JsonProperty("moduleName")
    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    /**
     * The name of the jar file that should be used when storing the binary data to in the module directory on the server. If this field is set the jar bits must be appended to this JSON message. If this field is set, the module will be created, otherwise the existence of the module given by moduleName and default slot "main" will be assumed.
     * 
     * @return
     *     The driverJarName
     */
    @JsonProperty("driverJarName")
    public String getDriverJarName() {
        return driverJarName;
    }

    /**
     * The name of the jar file that should be used when storing the binary data to in the module directory on the server. If this field is set the jar bits must be appended to this JSON message. If this field is set, the module will be created, otherwise the existence of the module given by moduleName and default slot "main" will be assumed.
     * 
     * @param driverJarName
     *     The driverJarName
     */
    @JsonProperty("driverJarName")
    public void setDriverJarName(String driverJarName) {
        this.driverJarName = driverJarName;
    }

}
