
package org.hawkular.cmdgw.api;

import javax.annotation.Generated;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;


/**
 * Results of a Resource related operation. The awkward name of the schema file A2ResourcePathResponse.schema.json is there so that this schema file precedes all other schema files alphabetically. This is required by jsonschema2pojo-maven-plugin that is not resolving the inter-schema dependencies, it just takes files in alphabetical order.
 * 
 */
@JsonInclude(JsonInclude.Include.NON_NULL)
@Generated("org.jsonschema2pojo")
@JsonPropertyOrder({
    "resourcePath",
    "senderRequestId",
    "destinationSessionId",
    "status",
    "message"
})
public class ResourcePathResponse
    extends AuthMessage
    implements UiSessionDestination
{

    /**
     * The inventory path to the resource that was targeted by the request.
     * (Required)
     * 
     */
    @JsonProperty("resourcePath")
    private String resourcePath;
    /**
     * An ID chosen originally by the sending UI client that should make it possible to associate this response with the triggering request. This ID is supposed to be unique just within the sending WebSocket session
     * 
     */
    @JsonProperty("senderRequestId")
    private String senderRequestId;
    /**
     * The ID of a WebSocket Session that is the destination of this message.
     * (Required)
     * 
     */
    @JsonProperty("destinationSessionId")
    private String destinationSessionId;
    /**
     * A status of a response
     * 
     */
    @JsonProperty("status")
    private ResponseStatus status;
    /**
     * A message that further describes the results of the operation.
     * 
     */
    @JsonProperty("message")
    private String message;

    /**
     * The inventory path to the resource that was targeted by the request.
     * (Required)
     * 
     * @return
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public String getResourcePath() {
        return resourcePath;
    }

    /**
     * The inventory path to the resource that was targeted by the request.
     * (Required)
     * 
     * @param resourcePath
     *     The resourcePath
     */
    @JsonProperty("resourcePath")
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    /**
     * An ID chosen originally by the sending UI client that should make it possible to associate this response with the triggering request. This ID is supposed to be unique just within the sending WebSocket session
     * 
     * @return
     *     The senderRequestId
     */
    @JsonProperty("senderRequestId")
    public String getSenderRequestId() {
        return senderRequestId;
    }

    /**
     * An ID chosen originally by the sending UI client that should make it possible to associate this response with the triggering request. This ID is supposed to be unique just within the sending WebSocket session
     * 
     * @param senderRequestId
     *     The senderRequestId
     */
    @JsonProperty("senderRequestId")
    public void setSenderRequestId(String senderRequestId) {
        this.senderRequestId = senderRequestId;
    }

    /**
     * The ID of a WebSocket Session that is the destination of this message.
     * (Required)
     * 
     * @return
     *     The destinationSessionId
     */
    @JsonProperty("destinationSessionId")
    public String getDestinationSessionId() {
        return destinationSessionId;
    }

    /**
     * The ID of a WebSocket Session that is the destination of this message.
     * (Required)
     * 
     * @param destinationSessionId
     *     The destinationSessionId
     */
    @JsonProperty("destinationSessionId")
    public void setDestinationSessionId(String destinationSessionId) {
        this.destinationSessionId = destinationSessionId;
    }

    /**
     * A status of a response
     * 
     * @return
     *     The status
     */
    @JsonProperty("status")
    public ResponseStatus getStatus() {
        return status;
    }

    /**
     * A status of a response
     * 
     * @param status
     *     The status
     */
    @JsonProperty("status")
    public void setStatus(ResponseStatus status) {
        this.status = status;
    }

    /**
     * A message that further describes the results of the operation.
     * 
     * @return
     *     The message
     */
    @JsonProperty("message")
    public String getMessage() {
        return message;
    }

    /**
     * A message that further describes the results of the operation.
     * 
     * @param message
     *     The message
     */
    @JsonProperty("message")
    public void setMessage(String message) {
        this.message = message;
    }

}
