/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.bus.sample.mdb;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import javax.jms.ConnectionFactory;
import javax.jms.QueueConnectionFactory;
import javax.naming.InitialContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.ConnectionContextFactory;
import org.hawkular.bus.common.Endpoint;
import org.hawkular.bus.common.MessageId;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.SimpleBasicMessage;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.bus.sample.mdb.QueueSendServlet;

public class QueueSendServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String CONN_FACTORY = "/HawkularBusConnectionFactory";
    private static final String QUEUE_NAME = "ExampleQueueName";
    private static final Map<String, String> FNF_HEADER = QueueSendServlet.createMyFilterHeader((String)"fnf");
    private static final Map<String, String> RPC_HEADER = QueueSendServlet.createMyFilterHeader((String)"rpc");

    public void service(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String userMessage = request.getParameter("jmsMessageFNF");
        if (userMessage != null) {
            this.fireAndForget(request, response, userMessage);
        } else {
            userMessage = request.getParameter("jmsMessageRPC");
            if (userMessage != null) {
                this.rpc(request, response, userMessage);
            } else {
                throw new ServletException("Don't know what to send!");
            }
        }
    }

    protected void fireAndForget(HttpServletRequest request, HttpServletResponse response, String userMessage) {
        try {
            InitialContext ctx = new InitialContext();
            QueueConnectionFactory qconFactory = (QueueConnectionFactory)ctx.lookup(CONN_FACTORY);
            ConnectionContextFactory ccf = new ConnectionContextFactory((ConnectionFactory)qconFactory);
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, QUEUE_NAME));
            SimpleBasicMessage msg = new SimpleBasicMessage(userMessage);
            MessageId mid = new MessageProcessor().send(pcc, (BasicMessage)msg, FNF_HEADER);
            PrintWriter out = response.getWriter();
            out.println("<h1>Fire and Forget</h1>");
            out.println("<p>Message Sent [" + msg + "]</p>");
            out.println("<p>(messageId=" + mid + ")</p>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void rpc(HttpServletRequest request, HttpServletResponse response, String userMessage) {
        try {
            InitialContext ctx = new InitialContext();
            QueueConnectionFactory qconFactory = (QueueConnectionFactory)ctx.lookup(CONN_FACTORY);
            ConnectionContextFactory ccf = new ConnectionContextFactory((ConnectionFactory)qconFactory);
            ProducerConnectionContext pcc = ccf.createProducerConnectionContext(new Endpoint(Endpoint.Type.QUEUE, QUEUE_NAME));
            SimpleBasicMessage msg = new SimpleBasicMessage(userMessage);
            ListenableFuture future = new MessageProcessor().sendRPC(pcc, (BasicMessage)msg, SimpleBasicMessage.class, RPC_HEADER);
            Futures.addCallback((ListenableFuture)future, (FutureCallback)new SimpleFutureCallback(this, null));
            PrintWriter out = response.getWriter();
            out.println("<h1>RPC</h1>");
            out.println("<p>Message Sent [" + msg + "]</p>");
            out.println("<p>Check server logs for response.</p>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static Map<String, String> createMyFilterHeader(String value) {
        HashMap<String, String> map = new HashMap<String, String>(1);
        map.put("MyFilter", value);
        return map;
    }
}

