/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.elasticsearch;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.apache.commons.io.IOUtils;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequestBuilder;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.hawkular.btm.server.elasticsearch.ElasticsearchEmbeddedNode;

@Singleton
public class ElasticsearchClient {
    private static final String HAWKULAR_BTM_MAPPING_JSON = "hawkular-btm-mapping.json";
    public static final String ELASTICSEARCH_HOSTS = "hawkular-btm.elasticsearch.hosts";
    public static final String ELASTICSEARCH_CLUSTER = "hawkular-btm.elasticsearch.cluster";
    public static final String SETTINGS = "settings";
    public static final String MAPPINGS = "mappings";
    public static final String DEFAULT_SETTING = "_default_";
    private static final Logger log = Logger.getLogger(ElasticsearchClient.class.getName());
    private Client client;
    private static final String ELASTICSEARCH_HOSTS_DEFAULT = "embedded";
    private String hosts;
    private static final String ELASTICSEARCH_CLUSTER_DEFAULT = "elasticsearch";
    private String cluster;
    private static final Object SYNC = new Object();
    private static ElasticsearchEmbeddedNode node = null;
    private static List<String> knownTenants = new ArrayList<String>();

    public ElasticsearchClient() {
        if (!System.getProperties().containsKey("hawkular-btm.data.dir")) {
            System.setProperty("hawkular-btm.data.dir", System.getProperty("jboss.server.data.dir"));
        }
        this.hosts = System.getProperty(ELASTICSEARCH_HOSTS, ELASTICSEARCH_HOSTS_DEFAULT);
        this.cluster = System.getProperty(ELASTICSEARCH_CLUSTER, ELASTICSEARCH_CLUSTER_DEFAULT);
    }

    public String getHosts() {
        return this.hosts;
    }

    public void setHosts(String hosts) {
        this.hosts = hosts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PostConstruct
    public void init() throws Exception {
        if (this.hosts == null) {
            throw new IllegalArgumentException("Hosts property not set ");
        }
        this.determineHostsAsProperty();
        if (this.hosts.startsWith(ELASTICSEARCH_HOSTS_DEFAULT)) {
            Object object = SYNC;
            synchronized (object) {
                if (node == null) {
                    node = new ElasticsearchEmbeddedNode();
                }
            }
            this.client = node.getClient();
        } else {
            String[] hostsArray = this.hosts.split(",");
            Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.cluster).build();
            TransportClient c = new TransportClient(settings);
            for (String aHostsArray : hostsArray) {
                String s = aHostsArray.trim();
                String[] host = s.split(":");
                if (log.isLoggable(Level.FINE)) {
                    log.fine(" Connecting to elasticsearch host. [" + host[0] + ":" + host[1] + "]");
                }
                c = c.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host[0], new Integer(host[1]).intValue()));
            }
            this.client = c;
        }
    }

    public String getIndex(String tenantId) {
        if (tenantId == null) {
            return "btm";
        }
        return "btm-" + tenantId.toLowerCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initTenant(String tenantId) throws Exception {
        if (!knownTenants.contains(tenantId)) {
            List<String> list = knownTenants;
            synchronized (list) {
                if (!knownTenants.contains(tenantId)) {
                    InputStream s;
                    if (log.isLoggable(Level.FINE)) {
                        log.fine("Initialise mappings for tenantId = " + tenantId);
                    }
                    if ((s = Thread.currentThread().getContextClassLoader().getResourceAsStream(HAWKULAR_BTM_MAPPING_JSON)) == null) {
                        s = ElasticsearchClient.class.getResourceAsStream("/hawkular-btm-mapping.json");
                    }
                    if (s != null) {
                        Map dataMap;
                        String index = this.getIndex(tenantId);
                        String jsonDefaultUserIndex = IOUtils.toString((InputStream)s);
                        if (log.isLoggable(Level.FINEST)) {
                            log.finest("Mapping [" + jsonDefaultUserIndex + "]");
                        }
                        if (this.createIndex(index, (Map)(dataMap = XContentFactory.xContent((CharSequence)jsonDefaultUserIndex).createParser(jsonDefaultUserIndex).mapAndClose()).get(SETTINGS))) {
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Index '" + index + "' created");
                            }
                            RefreshRequestBuilder refreshRequestBuilder = this.getElasticsearchClient().admin().indices().prepareRefresh(new String[]{index});
                            this.getElasticsearchClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                        } else if (log.isLoggable(Level.FINEST)) {
                            log.finest("Index '" + index + "' already exists. Doing nothing.");
                        }
                        this.prepareMapping(index, (Map)dataMap.get(MAPPINGS));
                        knownTenants.add(tenantId);
                    } else {
                        log.warning("Could not locate 'hawkular-btm-mapping.json' index mapping file. Mapping file required to use elasticsearch");
                    }
                }
            }
        }
    }

    private boolean prepareMapping(String index, Map<String, Object> defaultMappings) {
        boolean success = true;
        for (String type : defaultMappings.keySet()) {
            PutMappingResponse resp;
            Map mapping = (Map)defaultMappings.get(type);
            if (mapping == null) {
                throw new RuntimeException("type mapping not defined");
            }
            PutMappingRequestBuilder putMappingRequestBuilder = this.client.admin().indices().preparePutMapping(new String[0]).setIndices(new String[]{index});
            putMappingRequestBuilder.setType(type);
            putMappingRequestBuilder.setSource(mapping);
            if (log.isLoggable(Level.FINE)) {
                log.fine("Elasticsearch create mapping for index '" + index + " and type '" + type + "': " + mapping);
            }
            if ((resp = (PutMappingResponse)putMappingRequestBuilder.execute().actionGet()).isAcknowledged()) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine("Elasticsearch mapping for index '" + index + " and type '" + type + "' was acknowledged");
                continue;
            }
            success = false;
            log.warning("Elasticsearch mapping creation was not acknowledged for index '" + index + " and type '" + type + "'");
        }
        return success;
    }

    private boolean createIndex(String index, Map<String, Object> defaultSettings) {
        IndicesExistsResponse res = (IndicesExistsResponse)this.client.admin().indices().prepareExists(new String[]{index}).execute().actionGet();
        boolean created = false;
        if (!res.isExists()) {
            CreateIndexRequestBuilder req = this.client.admin().indices().prepareCreate(index);
            req.setSettings(defaultSettings);
            created = ((CreateIndexResponse)req.execute().actionGet()).isAcknowledged();
            if (!created) {
                throw new RuntimeException("Could not create index [" + index + "]");
            }
        }
        return created;
    }

    private void determineHostsAsProperty() {
        if (this.hosts.startsWith("${") && this.hosts.endsWith("}")) {
            String _hostsProperty = this.hosts.substring(2, this.hosts.length() - 1);
            this.hosts = System.getProperty(_hostsProperty);
            if (this.hosts == null) {
                throw new IllegalArgumentException("Could not find property '" + _hostsProperty + "'");
            }
        }
    }

    public Client getElasticsearchClient() {
        return this.client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clear(String tenantId) {
        List<String> list = knownTenants;
        synchronized (list) {
            knownTenants.remove(tenantId);
        }
    }

    @PreDestroy
    public void close() {
        if (node != null) {
            node.close();
        }
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public String toString() {
        return "ElasticsearchClient[hosts='" + this.hosts + "']";
    }
}

