/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.server.api.services;

import java.util.List;
import javax.inject.Inject;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.services.BusinessTransactionCriteria;
import org.hawkular.btm.api.services.BusinessTransactionService;
import org.hawkular.btm.server.api.processors.BusinessTransactionBus;
import org.jboss.logging.Logger;

public abstract class AbstractBusinessTransactionService
implements BusinessTransactionService {
    private final Logger log = Logger.getLogger(AbstractBusinessTransactionService.class);
    @Inject
    private BusinessTransactionBus bus;

    public void store(String tenantId, List<BusinessTransaction> btxns) throws Exception {
        this.log.tracef("Store business transactions: %s", btxns);
        if (btxns.size() == 0) {
            return;
        }
        for (int i = 0; i < btxns.size(); ++i) {
            this.doStore(tenantId, btxns.get(i));
        }
        if (this.bus != null) {
            this.bus.processFragments(tenantId, btxns);
        }
    }

    protected abstract void doStore(String var1, BusinessTransaction var2) throws Exception;

    public BusinessTransaction get(String tenantId, String id) {
        BusinessTransaction ret = this.doGet(tenantId, id);
        this.log.tracef("Get business transaction with id[%s] is: %s", (Object)id, (Object)ret);
        return ret;
    }

    protected abstract BusinessTransaction doGet(String var1, String var2);

    public List<BusinessTransaction> query(String tenantId, BusinessTransactionCriteria criteria) {
        List<BusinessTransaction> ret = this.doQuery(tenantId, criteria);
        this.log.tracef("Query business transactions with criteria[%s] is: %s", (Object)criteria, ret);
        return ret;
    }

    protected abstract List<BusinessTransaction> doQuery(String var1, BusinessTransactionCriteria var2);
}

