/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jboss.byteman.rule.exception.TypeException;

public class Type {
    private String typeName;
    private Class clazz;
    private String packageName;
    private int flags;
    private int nBytes;
    private Type aliasFor;
    private Type baseType;
    private Type arrayType;
    public static final int F_BOOLEAN = 1;
    public static final int F_INTEGRAL = 2;
    public static final int F_FLOATING = 4;
    public static final int F_OBJECT = 8;
    public static final int F_VOID = 16;
    public static final int F_ARRAY = 32;
    public static final int F_NUMERIC = 6;
    public static final int F_VALUE = 7;
    public static final int F_UNKNOWN = 4096;
    public static final int F_PRIMITIVE = 8192;
    public static final int F_STRING = 16384;
    public static final Type Z = new Type("boolean", Boolean.TYPE, 8193, 4);
    public static final Type B = new Type("byte", Byte.TYPE, 8194, 1);
    public static final Type S = new Type("short", Short.TYPE, 8194, 2);
    public static final Type C = new Type("char", Character.TYPE, 8194, 2);
    public static final Type I = new Type("int", Integer.TYPE, 8194, 4);
    public static final Type J = new Type("long", Long.TYPE, 8194, 8);
    public static final Type F = new Type("float", Float.TYPE, 8196, 4);
    public static final Type D = new Type("double", Double.TYPE, 8196, 8);
    public static final Type N = new Type("", null, 12294, 0);
    public static final Type BOOLEAN = new Type("java.lang.Boolean", Boolean.class, 1, 4);
    public static final Type BYTE = new Type("java.lang.Byte", Byte.class, 2, 4);
    public static final Type SHORT = new Type("java.lang.Short", Short.class, 2, 4);
    public static final Type CHARACTER = new Type("java.lang.Character", Character.class, 2, 4);
    public static final Type INTEGER = new Type("java.lang.Integer", Integer.class, 2, 4);
    public static final Type LONG = new Type("java.lang.Long", Long.class, 2, 4);
    public static final Type FLOAT = new Type("java.lang.Float", Float.class, 4, 4);
    public static final Type DOUBLE = new Type("java.lang.Double", Double.class, 4, 4);
    public static final Type STRING = new Type("java.lang.String", String.class, 16392, 4);
    public static final Type VOID = new Type("void", Void.TYPE, 16, 0);
    public static final Type NUMBER = new Type("java.lang.Number", Number.class, 6, 0);
    public static final Type OBJECT = new Type("java.lang.Object", Object.class, 8, 0);
    public static final Type UNDEFINED = new Type("", Undefined.class, 4096, 0);
    private static final HashMap<String, Type> builtinTypes = new HashMap();
    private static final HashMap<String, Type> primitiveTypes;
    private static final HashMap<Type, Type> boxedTypes;
    private static final HashMap<String, String> internalNames;

    public Type(String typeName, Class clazz) {
        this(typeName, clazz, 8, 4, null);
    }

    public Type(String typeName) {
        this(typeName, null);
    }

    public Type arrayType() {
        return this.arrayType(null);
    }

    public Type arrayType(Class clazz) {
        if (this.arrayType == null) {
            this.arrayType = new Type(this.typeName + "[]", clazz, 32, 4, this);
        }
        return this.arrayType;
    }

    public Type getBaseType() {
        if (this.isArray()) {
            return this.baseType;
        }
        return null;
    }

    public String getName() {
        return this.typeName;
    }

    public String getInternalName() {
        return this.getInternalName(false, true);
    }

    public String getInternalName(boolean forDescriptor, boolean slashSeparate) {
        String name;
        if (this.isArray()) {
            return "[" + this.baseType.getInternalName(true, slashSeparate);
        }
        if (this.isPrimitive()) {
            return internalNames.get(this.typeName);
        }
        if (this.isVoid()) {
            return internalNames.get(this.typeName);
        }
        Class targetClass = this.aliasFor.getTargetClass();
        Class<?> enclosingClass = targetClass.getEnclosingClass();
        if (enclosingClass != null && !forDescriptor) {
            name = targetClass.getName();
        } else {
            name = targetClass.getCanonicalName();
            if (name == null) {
                name = targetClass.getName();
            }
        }
        if (slashSeparate) {
            name = name.replace('.', '/');
        }
        if (forDescriptor) {
            name = "L" + name + ";";
        }
        return name;
    }

    public Class getTargetClass() {
        return this.clazz;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public static Type dereference(Type target) {
        if (target == null) {
            return null;
        }
        while (target.aliasFor != target) {
            target = target.aliasFor;
        }
        return target;
    }

    public void resolve(ClassLoader loader) {
        if (this.isDefined() || this == UNDEFINED || this == N) {
            return;
        }
        if (this.aliasFor != this) {
            this.aliasFor.resolve(loader);
            this.clazz = this.aliasFor.clazz;
            if (this.clazz != null) {
                this.flags &= 0xFFFFEFFF;
            }
        } else {
            try {
                this.clazz = loader.loadClass(this.getName());
                this.flags &= 0xFFFFEFFF;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (this.baseType != null) {
            this.baseType.resolve(loader);
        }
        if (this.arrayType != null) {
            this.arrayType.resolve(loader);
        }
    }

    public boolean aliasTo(Type target) {
        if (!this.isObject() || !target.isObject()) {
            return false;
        }
        if (this.packageName.length() != 0 || target.packageName.length() == 0) {
            return false;
        }
        if (this.aliasFor != this) {
            return this.aliasFor == target;
        }
        this.aliasFor = target;
        if (this.clazz != null) {
            if (target.clazz != null) {
                return false;
            }
            target.clazz = this.clazz;
            target.flags &= 0xFFFFEFFF;
        } else if (target.clazz != null) {
            this.clazz = target.clazz;
            this.flags &= 0xFFFFEFFF;
        }
        if (this.arrayType != null) {
            if (target.arrayType == null) {
                target.arrayType(target.clazz);
            }
            this.arrayType.aliasTo(target.arrayType);
        } else if (target.arrayType != null) {
            this.arrayType = this.arrayType(this.clazz);
            this.arrayType.aliasTo(target.arrayType);
        }
        return true;
    }

    public boolean isAssignableFrom(Type type) {
        if (this.aliasFor != this) {
            return Type.dereference(this).isAssignableFrom(type);
        }
        type = Type.dereference(type);
        if (this.isNumeric()) {
            return type.isNumeric();
        }
        if (this.isUndefined() || type.isUndefined()) {
            return false;
        }
        if (this == type) {
            return true;
        }
        if (this.isString()) {
            return true;
        }
        if (this.isVoid()) {
            return true;
        }
        if (this.isPrimitive()) {
            if (!type.isPrimitive()) {
                Type unboxedType = boxedTypes.get(type);
                return unboxedType == this;
            }
            return false;
        }
        if (type.isPrimitive()) {
            Type boxedType = boxedTypes.get(type);
            if (boxedType == this) {
                return true;
            }
            return this.clazz.isAssignableFrom(boxedType.clazz);
        }
        if (this.isObject() || this.isArray()) {
            return this.clazz.isAssignableFrom(type.clazz);
        }
        return false;
    }

    public boolean isUndefined() {
        return (this.flags & 0x1000) != 0;
    }

    public boolean isDefined() {
        return !this.isUndefined();
    }

    public boolean isUnbound() {
        return (this.flags & 0x1008) == 4104;
    }

    public boolean isPrimitive() {
        return (this.flags & 0x2000) != 0;
    }

    public boolean isValue() {
        return (this.flags & 7) != 0;
    }

    public boolean isVoid() {
        return (this.flags & 0x10) != 0;
    }

    public boolean isString() {
        return (this.flags & 0x4000) != 0;
    }

    public boolean isNumeric() {
        return (this.flags & 6) != 0;
    }

    public boolean isIntegral() {
        return (this.flags & 2) == 2;
    }

    public boolean isFloating() {
        return (this.flags & 4) == 4;
    }

    public boolean isBoolean() {
        return (this.flags & 1) != 0;
    }

    public boolean isObject() {
        return (this.flags & 8) != 0;
    }

    public boolean isArray() {
        return (this.flags & 0x20) != 0;
    }

    public int getNBytes() {
        return this.nBytes;
    }

    public static Type builtinType(Class clazz) {
        return builtinTypes.get(clazz.getName());
    }

    public static Type boxType(Class clazz) {
        Type type = Type.builtinType(clazz);
        return boxedTypes.get(type);
    }

    public static Type boxType(Type type) {
        return boxedTypes.get(type);
    }

    protected Type(String typeName, Class clazz, int flags, int nBytes) {
        this(typeName, clazz, flags, nBytes, null);
    }

    protected Type(String typeName, Class clazz, int flags, int nBytes, Type baseType) {
        this.typeName = typeName;
        if (clazz == null) {
            flags |= 0x1000;
        }
        this.clazz = clazz;
        this.flags = flags;
        this.nBytes = nBytes;
        if ((flags & 0x20) != 0) {
            this.baseType = baseType;
            baseType.arrayType = this;
        } else {
            this.baseType = null;
        }
        this.arrayType = null;
        this.aliasFor = this;
        this.packageName = Type.packagePart(typeName);
    }

    public static Type promote(Type type1, Type type2) throws TypeException {
        if (type1.isUndefined() || type2.isUndefined()) {
            return N;
        }
        if (!type1.isNumeric() || !type2.isNumeric()) {
            throw new TypeException("Type.promote : unexpected non-numeric type argument");
        }
        if (type1.isFloating() || type2.isFloating()) {
            if (type1 == DOUBLE || type2 == DOUBLE || type1 == D || type2 == D) {
                return D;
            }
            return F;
        }
        if (type1 == LONG || type2 == LONG || type1 == J || type2 == J) {
            return J;
        }
        if (type1 == INTEGER || type2 == INTEGER || type1 == I || type2 == I) {
            return I;
        }
        if (!(type1 != SHORT && type1 != S || type2 != SHORT && type2 != S)) {
            return S;
        }
        if (!(type1 != CHARACTER && type1 != C || type2 != CHARACTER && type2 != C)) {
            return C;
        }
        if (!(type1 != BYTE && type1 != B || type2 != BYTE && type2 != B)) {
            return B;
        }
        return I;
    }

    private static String packagePart(String className) {
        int dotIdx = className.lastIndexOf(46);
        if (dotIdx < 0) {
            return "";
        }
        return className.substring(0, dotIdx);
    }

    public static List<String> parseMethodDescriptor(String descriptor, boolean includeReturnType) {
        ArrayList<String> argTypes = new ArrayList<String>();
        int length = descriptor.length();
        int idx = descriptor.indexOf("(");
        int arrayDepth = 0;
        if (idx < 0) {
            return null;
        }
        ++idx;
        block14: while (idx < length) {
            char c = descriptor.charAt(idx);
            switch (descriptor.charAt(idx)) {
                case 'Z': {
                    String baseType = "boolean";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'B': {
                    String baseType = "byte";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'S': {
                    String baseType = "short";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'C': {
                    String baseType = "char";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'I': {
                    String baseType = "int";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'J': {
                    String baseType = "long";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'F': {
                    String baseType = "float";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'D': {
                    String baseType = "double";
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    ++idx;
                    continue block14;
                }
                case 'V': {
                    if (arrayDepth != 0) {
                        return null;
                    }
                    if (!includeReturnType) {
                        return null;
                    }
                    argTypes.add("void");
                    ++idx;
                    continue block14;
                }
                case 'L': {
                    int endIdx = descriptor.indexOf(59, idx);
                    if (endIdx < 0) {
                        return null;
                    }
                    String baseType = descriptor.substring(idx + 1, endIdx).replace('/', '.');
                    argTypes.add(Type.fixArrayType(baseType, arrayDepth));
                    arrayDepth = 0;
                    idx = endIdx + 1;
                    continue block14;
                }
                case '[': {
                    ++arrayDepth;
                    ++idx;
                    continue block14;
                }
                case ')': {
                    if (arrayDepth != 0) {
                        return null;
                    }
                    if (!includeReturnType) {
                        return argTypes;
                    }
                    ++idx;
                    while (idx < length && descriptor.charAt(idx) == ' ') {
                        ++idx;
                    }
                    if (idx != length) continue block14;
                    argTypes.add("void");
                    continue block14;
                }
            }
            return null;
        }
        return arrayDepth == 0 ? argTypes : null;
    }

    public static String parseFieldDescriptor(String descriptor) {
        int length = descriptor.length();
        int arrayDepth = 0;
        block13: for (int idx = 0; idx < length; ++idx) {
            char c = descriptor.charAt(idx);
            switch (descriptor.charAt(idx)) {
                case 'Z': {
                    String baseType = "boolean";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'B': {
                    String baseType = "byte";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'S': {
                    String baseType = "short";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'C': {
                    String baseType = "char";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'I': {
                    String baseType = "int";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'J': {
                    String baseType = "long";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'F': {
                    String baseType = "float";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'D': {
                    String baseType = "double";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'V': {
                    String baseType = "void";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'L': {
                    int endIdx = descriptor.indexOf(59, idx);
                    if (endIdx < 0) {
                        return null;
                    }
                    String baseType = descriptor.substring(idx + 1, endIdx).replace('/', '.');
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case '[': {
                    ++arrayDepth;
                    continue block13;
                }
            }
            return null;
        }
        return null;
    }

    public static String parseMethodReturnType(String descriptor) {
        int length = descriptor.length();
        int idx = descriptor.indexOf(")");
        int arrayDepth = 0;
        if (idx < 0) {
            return "void";
        }
        ++idx;
        block13: while (idx < length) {
            char c = descriptor.charAt(idx);
            switch (c) {
                case 'Z': {
                    String baseType = "boolean";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'B': {
                    String baseType = "byte";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'S': {
                    String baseType = "short";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'C': {
                    String baseType = "char";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'I': {
                    String baseType = "int";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'J': {
                    String baseType = "long";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'F': {
                    String baseType = "float";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'D': {
                    String baseType = "double";
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case 'V': {
                    return "void";
                }
                case 'L': {
                    int endIdx = descriptor.indexOf(59, idx);
                    if (endIdx < 0) {
                        return "void";
                    }
                    String baseType = descriptor.substring(idx + 1, endIdx).replace('/', '.');
                    return Type.fixArrayType(baseType, arrayDepth);
                }
                case '[': {
                    ++arrayDepth;
                    ++idx;
                    continue block13;
                }
            }
            return "void";
        }
        return "void";
    }

    public static int paramSlotIdx(int access, String desc, int paramIdx) {
        boolean isStatic;
        boolean bl = isStatic = (access & 8) != 0;
        if (paramIdx == 0) {
            if (isStatic) {
                return -1;
            }
            return 0;
        }
        int slotIdx = isStatic ? 0 : 1;
        int descIdx = 0;
        char[] chars = desc.toCharArray();
        char next = chars[descIdx++];
        if (next == '(') {
            next = chars[descIdx++];
        }
        for (int i = 1; i < paramIdx; ++i) {
            switch (next) {
                case 'B': 
                case 'C': 
                case 'F': 
                case 'I': 
                case 'S': 
                case 'Z': {
                    ++slotIdx;
                    break;
                }
                case 'D': 
                case 'J': {
                    slotIdx += 2;
                    break;
                }
                case 'L': {
                    ++slotIdx;
                    while (next != ';') {
                        next = chars[descIdx++];
                    }
                    break;
                }
                case '[': {
                    ++slotIdx;
                    while (next == '[') {
                        next = chars[descIdx++];
                    }
                    if (next != 'L') break;
                    while (next != ';') {
                        next = chars[descIdx++];
                    }
                    break;
                }
                default: {
                    return -1;
                }
            }
            next = chars[descIdx++];
        }
        return slotIdx;
    }

    public static String fixArrayType(String baseType, int dimension) {
        String result = baseType;
        for (int i = 0; i < dimension; ++i) {
            result = result + "[]";
        }
        return result;
    }

    public static String internalName(Class<?> clazz) {
        return Type.internalName(clazz, false);
    }

    public static String internalName(Class<?> clazz, boolean forField) {
        if (clazz.isPrimitive()) {
            if (forField) {
                return internalNames.get(clazz.getName());
            }
            return clazz.getName();
        }
        if (clazz.isArray()) {
            Class<?> base = clazz.getComponentType();
            return "[" + Type.internalName(base, true);
        }
        if (forField) {
            return "L" + clazz.getName().replace('.', '/') + ";";
        }
        return clazz.getName().replace('.', '/');
    }

    public String toString() {
        return this.getName();
    }

    static {
        builtinTypes.put(Z.getName(), Z);
        builtinTypes.put(B.getName(), B);
        builtinTypes.put(S.getName(), S);
        builtinTypes.put(C.getName(), C);
        builtinTypes.put(I.getName(), I);
        builtinTypes.put(J.getName(), J);
        builtinTypes.put(F.getName(), F);
        builtinTypes.put(D.getName(), D);
        builtinTypes.put("$number$", N);
        builtinTypes.put(BOOLEAN.getTargetClass().getName(), BOOLEAN);
        builtinTypes.put(BYTE.getTargetClass().getName(), BYTE);
        builtinTypes.put(SHORT.getTargetClass().getName(), SHORT);
        builtinTypes.put(CHARACTER.getTargetClass().getName(), CHARACTER);
        builtinTypes.put(INTEGER.getTargetClass().getName(), INTEGER);
        builtinTypes.put(LONG.getTargetClass().getName(), LONG);
        builtinTypes.put(FLOAT.getTargetClass().getName(), FLOAT);
        builtinTypes.put(STRING.getTargetClass().getName(), STRING);
        builtinTypes.put(VOID.getTargetClass().getName(), VOID);
        builtinTypes.put(NUMBER.getTargetClass().getName(), NUMBER);
        builtinTypes.put(UNDEFINED.getTargetClass().getName(), UNDEFINED);
        builtinTypes.put(OBJECT.getTargetClass().getName(), OBJECT);
        builtinTypes.put("Boolean", BOOLEAN);
        builtinTypes.put("Byte", BYTE);
        builtinTypes.put("Short", SHORT);
        builtinTypes.put("Character", CHARACTER);
        builtinTypes.put("Integer", INTEGER);
        builtinTypes.put("Long", LONG);
        builtinTypes.put("Float", FLOAT);
        builtinTypes.put("String", STRING);
        builtinTypes.put("Number", NUMBER);
        builtinTypes.put("Object", OBJECT);
        builtinTypes.put("", UNDEFINED);
        builtinTypes.put("Undefined", UNDEFINED);
        primitiveTypes = new HashMap();
        primitiveTypes.put(Z.getName(), Z);
        primitiveTypes.put(B.getName(), B);
        primitiveTypes.put(S.getName(), S);
        primitiveTypes.put(C.getName(), C);
        primitiveTypes.put(I.getName(), I);
        primitiveTypes.put(J.getName(), J);
        primitiveTypes.put(F.getName(), F);
        primitiveTypes.put(D.getName(), D);
        primitiveTypes.put("$number$", N);
        boxedTypes = new HashMap();
        boxedTypes.put(Z, BOOLEAN);
        boxedTypes.put(B, BYTE);
        boxedTypes.put(S, SHORT);
        boxedTypes.put(C, CHARACTER);
        boxedTypes.put(I, INTEGER);
        boxedTypes.put(J, LONG);
        boxedTypes.put(F, FLOAT);
        boxedTypes.put(D, DOUBLE);
        boxedTypes.put(BOOLEAN, Z);
        boxedTypes.put(BYTE, B);
        boxedTypes.put(SHORT, S);
        boxedTypes.put(CHARACTER, C);
        boxedTypes.put(INTEGER, I);
        boxedTypes.put(LONG, J);
        boxedTypes.put(FLOAT, F);
        boxedTypes.put(DOUBLE, D);
        internalNames = new HashMap();
        internalNames.put("Z", "boolean");
        internalNames.put("B", "byte");
        internalNames.put("S", "short");
        internalNames.put("C", "char");
        internalNames.put("I", "int");
        internalNames.put("J", "long");
        internalNames.put("F", "float");
        internalNames.put("D", "double");
        internalNames.put("V", "void");
        internalNames.put("boolean", "Z");
        internalNames.put("byte", "B");
        internalNames.put("short", "S");
        internalNames.put("char", "C");
        internalNames.put("int", "I");
        internalNames.put("long", "J");
        internalNames.put("float", "F");
        internalNames.put("double", "D");
        internalNames.put("void", "V");
    }

    private static class Undefined {
        private Undefined() {
        }
    }
}

