/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class NullLiteral
extends Expression {
    public NullLiteral(Rule rule, ParseNode token) {
        super(rule, Type.UNDEFINED, token);
    }

    @Override
    public void bind() {
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        this.type = expected == Type.VOID || expected.isUndefined() ? Type.OBJECT : (expected.isPrimitive() ? Type.boxType(expected) : expected);
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        return null;
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        mv.visitInsn(1);
        compileContext.addStackCount(1);
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        stringWriter.write("null");
    }
}

