/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import java.lang.reflect.Array;
import java.util.List;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.compiler.CompileContext;
import org.jboss.byteman.rule.exception.CompileException;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.expression.Expression;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public class ArrayInitExpression
extends Expression {
    List<Expression> elements;

    public ArrayInitExpression(Rule rule, Type type, ParseNode token, List<Expression> elements) {
        super(rule, type, token);
        this.elements = elements;
    }

    @Override
    public void bind() throws TypeException {
        for (Expression element : this.elements) {
            element.bind();
        }
    }

    @Override
    public Type typeCheck(Type expected) throws TypeException {
        Type baseType;
        if (this.type.isUndefined()) {
            baseType = Type.UNDEFINED;
        } else if (this.type.isArray()) {
            baseType = this.type.getBaseType();
        } else {
            throw new TypeException("ArrayInitExpression.typeCheck : cannot initialise non-array type from array list " + this.type.getName() + this.getPos());
        }
        for (Expression element : this.elements) {
            Type t = element.typeCheck(baseType);
            if (!baseType.isUndefined()) continue;
            baseType = t;
        }
        if (this.type.isUndefined()) {
            this.type = baseType.arrayType();
        }
        return this.type;
    }

    @Override
    public Object interpret(HelperAdapter helper) throws ExecuteException {
        try {
            Class clazz = this.type.getBaseType().getTargetClass();
            Object array = Array.newInstance(clazz, this.elements.size());
            int idx = 0;
            for (Expression element : this.elements) {
                Object value = element.interpret(helper);
                Array.set(array, idx++, value);
            }
            return array;
        }
        catch (ExecuteException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ExecuteException("ArrayInitExpression.interpret : unexpected exception initialising array " + this.token.getText() + this.getPos(), e);
        }
    }

    @Override
    public void compile(MethodVisitor mv, CompileContext compileContext) throws CompileException {
        compileContext.notifySourceLine(this.line);
        Type baseType = this.getType().getBaseType();
        int currentStack = compileContext.getStackCount();
        int expected = 1;
        int length = this.elements.size();
        mv.visitLdcInsn(length);
        compileContext.addStackCount(1);
        if (baseType.isObject()) {
            mv.visitTypeInsn(188, baseType.getInternalName());
        } else {
            int operand = 0;
            if (baseType.equals(Type.Z)) {
                operand = 4;
            } else if (baseType.equals(Type.B)) {
                operand = 8;
            } else if (baseType.equals(Type.S)) {
                operand = 9;
            } else if (baseType.equals(Type.C)) {
                operand = 5;
            } else if (baseType.equals(Type.I)) {
                operand = 10;
            } else if (baseType.equals(Type.J)) {
                operand = 11;
            } else if (baseType.equals(Type.F)) {
                operand = 6;
            } else if (baseType.equals(Type.D)) {
                operand = 7;
            }
            mv.visitIntInsn(188, operand);
        }
        int idx = 0;
        boolean isTwoWords = baseType.getNBytes() > 4;
        for (Expression element : this.elements) {
            int toPop = 0;
            mv.visitInsn(89);
            mv.visitLdcInsn(idx);
            compileContext.addStackCount(2);
            element.compile(mv, compileContext);
            this.compileTypeConversion(element.type, baseType, mv, compileContext);
            if (baseType.isObject() || baseType.isArray()) {
                mv.visitInsn(83);
                toPop = -3;
            } else if (baseType == Type.Z || baseType == Type.B) {
                mv.visitInsn(84);
                toPop = -3;
            } else if (baseType == Type.S) {
                mv.visitInsn(86);
                toPop = -3;
            } else if (baseType == Type.C) {
                mv.visitInsn(85);
                toPop = -3;
            } else if (baseType == Type.I) {
                mv.visitInsn(79);
                toPop = -3;
            } else if (baseType == Type.J) {
                mv.visitInsn(80);
                toPop = -4;
            } else if (baseType == Type.F) {
                mv.visitInsn(81);
                toPop = -3;
            } else if (baseType == Type.D) {
                mv.visitInsn(82);
                toPop = -4;
            }
            compileContext.addStackCount(toPop);
        }
        if (compileContext.getStackCount() != currentStack + expected) {
            throw new CompileException("ArrayInitExpression.compile : invalid stack height " + compileContext.getStackCount() + " expecting " + (currentStack + expected));
        }
    }

    @Override
    public void writeTo(StringWriter stringWriter) {
        String prefix = "{ ";
        for (Expression expr : this.elements) {
            stringWriter.write(prefix);
            expr.writeTo(stringWriter);
            prefix = ",\n  ";
        }
        stringWriter.write("};\n");
    }
}

