/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.compiler;

import org.jboss.byteman.rule.exception.CompileException;

public class StackHeights {
    public int stackCount;
    public int localCount;

    public StackHeights() {
        this.localCount = 0;
        this.stackCount = 0;
    }

    public StackHeights(StackHeights toCopy) {
        this.stackCount = toCopy.stackCount;
        this.localCount = toCopy.localCount;
    }

    public StackHeights addStackCount(int increment) throws CompileException {
        this.stackCount += increment;
        if (this.stackCount < 0) {
            throw new CompileException("StackHeights.addStackCount : negative count for stack slots!");
        }
        return this;
    }

    public StackHeights addLocalCount(int increment) throws CompileException {
        this.localCount += increment;
        if (this.localCount < 0) {
            throw new CompileException("StackHeights.addLocalCount : negative count for local variable slots!");
        }
        return this;
    }
}

