/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.client.manager;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import org.hawkular.btm.api.logging.Logger;
import org.hawkular.btm.api.model.config.CollectorConfiguration;
import org.hawkular.btm.api.model.config.instrumentation.Instrumentation;
import org.hawkular.btm.api.services.ConfigurationService;
import org.hawkular.btm.api.services.ServiceResolver;
import org.hawkular.btm.client.api.BusinessTransactionCollector;
import org.hawkular.btm.client.manager.config.Transformer;
import org.jboss.byteman.agent.Retransformer;

public class ClientManager {
    private static final Logger log = Logger.getLogger((String)ClientManager.class.getName());
    private static Retransformer transformer;
    private static Transformer ruleTransformer;
    private static BusinessTransactionCollector collector;
    private static ConfigurationService configService;

    public static void initialize(Retransformer trans) {
        log.info("BTM: Initializing Client Manager");
        transformer = trans;
        CompletableFuture colFuture = ServiceResolver.getSingletonService(BusinessTransactionCollector.class);
        colFuture.whenComplete(new BiConsumer<BusinessTransactionCollector, Throwable>(){

            @Override
            public void accept(BusinessTransactionCollector c, Throwable t) {
                log.info("BTM: Initialising Business Transaction Collector: " + c + " exception=" + t);
                if (c != null) {
                    collector = c;
                } else if (t != null) {
                    System.err.println("Failed to locate Business Transaction Collector: " + t);
                    t.printStackTrace();
                }
            }
        });
        CompletableFuture asFuture = ServiceResolver.getSingletonService(ConfigurationService.class);
        asFuture.whenComplete(new BiConsumer<ConfigurationService, Throwable>(){

            @Override
            public void accept(ConfigurationService cs, Throwable t) {
                log.info("BTM: Initialising Configuration Service: " + cs + " exception=" + t);
                configService = cs;
                if (configService == null) {
                    System.err.println("Unable to locate Configuration Service: " + t);
                    if (t != null) {
                        t.printStackTrace();
                    }
                } else {
                    CollectorConfiguration config = configService.getCollector(null, null, null);
                    if (config != null) {
                        try {
                            ClientManager.updateInstrumentation(config);
                        }
                        catch (Exception e) {
                            System.err.println("Failed to update instrumentation rules: " + e);
                            e.printStackTrace();
                        }
                    }
                }
            }
        });
    }

    protected static BusinessTransactionCollector collector() {
        return collector;
    }

    public static void updateInstrumentation(CollectorConfiguration config) throws Exception {
        ArrayList<String> scripts = new ArrayList<String>();
        ArrayList<String> scriptNames = new ArrayList<String>();
        Map instrumentTypes = config.getInstrumentation();
        for (String name : instrumentTypes.keySet()) {
            Instrumentation types = (Instrumentation)instrumentTypes.get(name);
            String rules = ruleTransformer.transform(name, types, config.getProperty("version." + name, null));
            if (log.isLoggable(Logger.Level.FINER)) {
                log.finer("Update instrumentation script name=" + name + " rules=" + rules);
            }
            if (rules == null) continue;
            scriptNames.add(name);
            scripts.add(rules);
        }
        PrintWriter writer = new PrintWriter(new StringWriter());
        transformer.installScript(scripts, scriptNames, writer);
        writer.close();
    }

    static {
        ruleTransformer = new Transformer();
    }
}

