/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.btm.api.services;

import io.swagger.annotations.ApiModel;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.btm.api.model.btxn.BusinessTransaction;
import org.hawkular.btm.api.model.btxn.CorrelationIdentifier;
import org.hawkular.btm.api.model.btxn.Node;
import org.hawkular.btm.api.services.BaseCriteria;

@ApiModel(parent=BaseCriteria.class)
public class BusinessTransactionCriteria
extends BaseCriteria {
    private final Logger log = Logger.getLogger(BusinessTransactionCriteria.class.getName());
    private Set<CorrelationIdentifier> correlationIds = new HashSet<CorrelationIdentifier>();

    public Set<CorrelationIdentifier> getCorrelationIds() {
        return this.correlationIds;
    }

    public BusinessTransactionCriteria setCorrelationIds(Set<CorrelationIdentifier> correlationIds) {
        this.correlationIds = correlationIds;
        return this;
    }

    public boolean isValid(BusinessTransaction btxn) {
        if (this.getStartTime() > 0L && btxn.getStartTime() < this.getStartTime()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("Start time out of range");
            }
            return false;
        }
        if (this.getEndTime() > 0L && btxn.getStartTime() > this.getEndTime()) {
            if (this.log.isLoggable(Level.FINEST)) {
                this.log.finest("End time out of range");
            }
            return false;
        }
        if (this.getBusinessTransaction() != null) {
            if (this.getBusinessTransaction().trim().length() == 0) {
                if (btxn.getName() != null) {
                    if (this.log.isLoggable(Level.FINEST)) {
                        this.log.finest("Business transaction name is defined");
                    }
                    return false;
                }
            } else if (!this.getBusinessTransaction().equals(btxn.getName())) {
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Business transaction name mismatch, was '" + btxn.getName() + "' required '" + this.getBusinessTransaction() + "'");
                }
                return false;
            }
        }
        if (!this.getProperties().isEmpty()) {
            for (BaseCriteria.PropertyCriteria property : this.getProperties()) {
                String value = btxn.getProperties().get(property.getName());
                if (value == null) {
                    if (property.isExcluded()) continue;
                    this.log.finest("Property '" + property.getName() + "' not found");
                    return false;
                }
                if (property.getValue().equals(value) != property.isExcluded()) continue;
                if (this.log.isLoggable(Level.FINEST)) {
                    this.log.finest("Property match failed: criteria=" + property + " txn property value=" + value);
                }
                return false;
            }
        }
        if (!this.correlationIds.isEmpty()) {
            for (CorrelationIdentifier ci : this.correlationIds) {
                Set<Node> nodes = btxn.getCorrelatedNodes(ci);
                if (nodes.isEmpty()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public Map<String, String> parameters() {
        Map<String, String> ret = super.parameters();
        if (!this.getCorrelationIds().isEmpty()) {
            boolean first = true;
            StringBuilder buf = new StringBuilder();
            for (CorrelationIdentifier cid : this.getCorrelationIds()) {
                if (first) {
                    first = false;
                } else {
                    buf.append(',');
                }
                buf.append(cid.getScope().name());
                buf.append('|');
                buf.append(cid.getValue());
            }
            ret.put("correlations", buf.toString());
        }
        if (this.log.isLoggable(Level.FINEST)) {
            this.log.finest("BusinessTransactionCriteria parameters [" + ret + "]");
        }
        return ret;
    }

    @Override
    public String toString() {
        return "BusinessTransactionCriteria [correlationIds=" + this.correlationIds + ", toString()=" + super.toString() + "]";
    }
}

