/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.tracecompletiontime;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.processor.tracecompletiontime.TraceCompletionInformation;
import org.hawkular.apm.processor.tracecompletiontime.TraceCompletionInformationUtil;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;

public class TraceCompletionInformationInitiator
extends AbstractProcessor<Trace, TraceCompletionInformation> {
    private static final Logger log = Logger.getLogger(TraceCompletionInformationInitiator.class.getName());

    public TraceCompletionInformationInitiator() {
        super(Processor.ProcessorType.OneToOne);
    }

    public TraceCompletionInformation processOneToOne(String tenantId, Trace item) throws RetryAttemptException {
        Node n;
        if (!item.getNodes().isEmpty() && ((n = (Node)item.getNodes().get(0)).getClass() != Consumer.class || n.getCorrelationIds(CorrelationIdentifier.Scope.Interaction).isEmpty())) {
            TraceCompletionInformation ci = new TraceCompletionInformation();
            CompletionTime ct = new CompletionTime();
            ct.setId(item.getId());
            ct.setUri(n.getUri());
            ct.setOperation(n.getOperation());
            if (n.getClass() == Consumer.class) {
                ct.setEndpointType(((Consumer)n).getEndpointType());
            }
            ct.setBusinessTransaction(item.getBusinessTransaction());
            ct.setDuration(item.calculateDuration());
            ct.setPrincipal(item.getPrincipal());
            ct.setFault(n.getFault());
            ct.setProperties(item.getProperties());
            ct.setTimestamp(item.getStartTime());
            ci.setCompletionTime(ct);
            TraceCompletionInformationUtil.initialiseCommunications(ci, ((Node)item.getNodes().get(0)).getBaseTime(), 0L, n);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Creating initial completion time information = " + ci);
            }
            return ci;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("No completion information initiated for trace fragment = " + item);
        }
        return null;
    }

    public List<TraceCompletionInformation> processOneToMany(String tenantId, Trace item) throws RetryAttemptException {
        return null;
    }
}

