/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.tracecompletiontime;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.processor.tracecompletiontime.CommunicationDetailsCache;
import org.hawkular.apm.processor.tracecompletiontime.TraceCompletionInformation;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;

public class TraceCompletionInformationProcessor
extends AbstractProcessor<TraceCompletionInformation, TraceCompletionInformation> {
    private static final Logger log = Logger.getLogger(TraceCompletionInformationProcessor.class.getName());
    private static final long DEFAULT_DELAY = 500L;
    @Inject
    private CommunicationDetailsCache communicationDetailsCache;

    public TraceCompletionInformationProcessor() {
        super(Processor.ProcessorType.OneToOne);
    }

    public long getDeliveryDelay(List<TraceCompletionInformation> results) {
        return 500L;
    }

    public CommunicationDetailsCache getCommunicationDetailsCache() {
        return this.communicationDetailsCache;
    }

    public void setCommunicationDetailsCache(CommunicationDetailsCache communicationDetailsCache) {
        this.communicationDetailsCache = communicationDetailsCache;
    }

    public TraceCompletionInformation processOneToOne(String tenantId, TraceCompletionInformation item) throws RetryAttemptException {
        if (!item.getCommunications().isEmpty()) {
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < item.getCommunications().size(); ++i) {
                TraceCompletionInformation.Communication c = item.getCommunications().get(i);
                if (c.getExpire() < currentTime) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Completion info " + item + ": communication expired = " + c);
                    }
                    item.getCommunications().remove(i);
                    --i;
                    continue;
                }
                if (c.isMultipleConsumers()) continue;
                CommunicationDetails cd = null;
                for (int j = 0; cd == null && j < c.getIds().size(); ++j) {
                    cd = (CommunicationDetails)this.communicationDetailsCache.get(tenantId, c.getIds().get(j));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Completion info " + item + ": communication details for communication " + c + " = " + cd);
                }
                if (cd == null) continue;
                long targetFragmentBaseDuration = c.getBaseDuration() + cd.getLatency();
                long durationWithTargetFragment = targetFragmentBaseDuration + cd.getTargetFragmentDuration();
                if (durationWithTargetFragment > item.getCompletionTime().getDuration()) {
                    item.getCompletionTime().setDuration(durationWithTargetFragment);
                }
                if (!cd.getProperties().isEmpty()) {
                    item.getCompletionTime().getProperties().addAll(cd.getProperties());
                }
                for (int j = 0; j < cd.getOutbound().size(); ++j) {
                    CommunicationDetails.Outbound ob = (CommunicationDetails.Outbound)cd.getOutbound().get(j);
                    TraceCompletionInformation.Communication newc = new TraceCompletionInformation.Communication();
                    newc.setIds(ob.getIds());
                    newc.setMultipleConsumers(ob.isMultiConsumer());
                    newc.setBaseDuration(targetFragmentBaseDuration + ob.getProducerOffset());
                    newc.setExpire(System.currentTimeMillis() + 60000L);
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Completion info " + item + ": new communication = " + newc);
                    }
                    item.getCommunications().add(newc);
                }
                item.getCommunications().remove(i);
                --i;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Updated completion information = " + item);
            }
            return item;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("No communications to be processed for completion information = " + item);
        }
        return null;
    }
}

