/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.common;

import org.hawkular.apm.api.model.trace.Consumer;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.model.trace.Producer;
import org.hawkular.apm.tests.common.ApmMockServer;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;

public abstract class ClientTestBase {
    private ApmMockServer apmMockServer = new ApmMockServer();

    public int getPort() {
        return 8080;
    }

    @Before
    public void init() {
        try {
            this.apmMockServer.setPort(this.getPort());
            this.apmMockServer.setShutdownTimer(-1);
            this.apmMockServer.run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.setProcessHeaders(false);
        this.setProcessContent(false);
    }

    @After
    public void close() {
        try {
            this.apmMockServer.shutdown();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ApmMockServer getApmMockServer() {
        return this.apmMockServer;
    }

    public void setApmMockServer(ApmMockServer testAPMServer) {
        this.apmMockServer = testAPMServer;
    }

    protected void checkInteractionCorrelationIdentifiers(Producer producer, Consumer consumer) {
        CorrelationIdentifier pcid = (CorrelationIdentifier)producer.getCorrelationIds().iterator().next();
        CorrelationIdentifier ccid = (CorrelationIdentifier)consumer.getCorrelationIds().iterator().next();
        Assert.assertEquals((Object)pcid, (Object)ccid);
    }

    protected void setProcessHeaders(boolean b) {
        System.setProperty("hawkular-apm.test.process.headers", "" + b);
    }

    protected void setProcessContent(boolean b) {
        System.setProperty("hawkular-apm.test.process.content", "" + b);
    }

    protected boolean isProcessHeaders() {
        return Boolean.getBoolean("hawkular-apm.test.process.headers");
    }

    protected boolean isProcessContent() {
        return Boolean.getBoolean("hawkular-apm.test.process.content");
    }
}

