/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.app.vertx.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.hawkular.apm.client.opentracing.APMTracer;
import org.hawkular.apm.tests.app.vertx.opentracing.AccountManager;
import org.hawkular.apm.tests.app.vertx.opentracing.HttpHeadersExtractAdapter;
import org.hawkular.apm.tests.app.vertx.opentracing.InventoryManager;
import org.hawkular.apm.tests.app.vertx.opentracing.OrderLog;
import org.hawkular.apm.tests.app.vertx.opentracing.VertxMessageInjectAdapter;

public class OrderManager {
    private Map<String, JsonObject> orders = new HashMap<String, JsonObject>();
    private Vertx vertx;
    private EventBus eb;
    private Tracer tracer = new APMTracer();

    public static void main(String[] args) {
        OrderManager om = new OrderManager();
        om.run();
    }

    public void run() {
        this.vertx = Vertx.vertx();
        this.eb = this.vertx.eventBus();
        AccountManager.create(this.eb, this.tracer);
        OrderLog.create(this.eb, this.tracer);
        InventoryManager.create(this.eb, this.tracer);
        Router router = Router.router((Vertx)this.vertx);
        router.route(HttpMethod.POST, "/orders").handler(this::handlePlaceOrder);
        router.route(HttpMethod.GET, "/orders").handler(this::handleListOrders);
        this.vertx.createHttpServer().requestHandler(arg_0 -> ((Router)router).accept(arg_0)).listen(8180);
    }

    private void handlePlaceOrder(RoutingContext routingContext) {
        routingContext.request().bodyHandler(buf -> {
            SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new HttpHeadersExtractAdapter(routingContext.request().headers()));
            Span ordersConsumerSpan = this.tracer.buildSpan("POST").asChildOf(spanCtx).withTag("http.url", "/orders").withTag("service", "OrderManager").withTag("transaction", "Place Order").start();
            JsonObject order = buf.toJsonObject();
            HttpServerResponse response = routingContext.response();
            if (this.orders.containsKey(order.getValue("id"))) {
                this.sendError(400, "Order id must not be defined", response, ordersConsumerSpan);
            } else {
                this.checkAccount(order, response, ordersConsumerSpan);
            }
        });
    }

    private void checkAccount(JsonObject order, HttpServerResponse response, Span parentSpan) {
        Span getAccountSpan = this.tracer.buildSpan("GetAccount").asChildOf(parentSpan).start();
        this.tracer.inject(getAccountSpan.context(), Format.Builtin.TEXT_MAP, (Object)new VertxMessageInjectAdapter(order));
        this.eb.send("AccountManager.getAccount", (Object)order, acctresp -> {
            getAccountSpan.finish();
            if (acctresp.succeeded()) {
                this.checkStock(order, response, parentSpan);
            } else {
                this.sendError(500, acctresp.cause().getMessage(), response, parentSpan);
            }
        });
    }

    protected void checkStock(JsonObject order, HttpServerResponse response, Span parentSpan) {
        Span getItemSpan = this.tracer.buildSpan("GetItem").asChildOf(parentSpan).start();
        this.tracer.inject(getItemSpan.context(), Format.Builtin.TEXT_MAP, (Object)new VertxMessageInjectAdapter(order));
        this.eb.send("InventoryManager.getItem", (Object)order, invresp -> {
            getItemSpan.finish();
            if (invresp.succeeded()) {
                JsonObject item = (JsonObject)((Message)invresp.result()).body();
                if (order.getInteger("quantity", Integer.valueOf(1)) <= item.getInteger("quantity", Integer.valueOf(1))) {
                    VertxMessageInjectAdapter.cleanup(order);
                    order.put("id", UUID.randomUUID().toString());
                    this.orders.put(order.getString("id"), order);
                    response.putHeader("content-type", "application/json").setStatusCode(202).end(order.encodePrettily());
                    parentSpan.setTag("orderId", order.getString("id"));
                    parentSpan.setTag("itemId", order.getString("itemId"));
                    parentSpan.setTag("accountId", order.getString("accountId"));
                    parentSpan.finish();
                    this.orderConfirmed(order, parentSpan);
                } else {
                    this.sendError(500, "Out of stock", response, parentSpan);
                }
            } else {
                this.sendError(500, invresp.cause().getMessage(), response, parentSpan);
            }
        });
    }

    protected void orderConfirmed(JsonObject order, Span parentSpan) {
        try (Span orderConfirmedSpan = this.tracer.buildSpan("OrderConfirmed").addReference("follows_from", parentSpan.context()).start();){
            this.tracer.inject(orderConfirmedSpan.context(), Format.Builtin.TEXT_MAP, (Object)new VertxMessageInjectAdapter(order));
            this.eb.publish("Orders.confirmed", (Object)order);
        }
    }

    private void handleListOrders(RoutingContext routingContext) {
        routingContext.request().bodyHandler(buf -> {
            SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new HttpHeadersExtractAdapter(routingContext.request().headers()));
            Span listOrdersSpan = this.tracer.buildSpan("GET").asChildOf(spanCtx).withTag("http.url", "/orders").withTag("service", "OrderManager").withTag("transaction", "List My Orders").start();
            JsonObject acct = buf.toJsonObject();
            HttpServerResponse response = routingContext.response();
            Span getOrdersSpan = this.tracer.buildSpan("GetOrdersFromLog").asChildOf(listOrdersSpan).start();
            this.tracer.inject(getOrdersSpan.context(), Format.Builtin.TEXT_MAP, (Object)new VertxMessageInjectAdapter(acct));
            this.eb.send("OrderLog.getOrders", (Object)acct, logresp -> {
                getOrdersSpan.finish();
                if (logresp.succeeded()) {
                    JsonArray orders = (JsonArray)((Message)logresp.result()).body();
                    response.putHeader("content-type", "application/json").setStatusCode(200).end(orders.encodePrettily());
                    listOrdersSpan.finish();
                } else {
                    this.sendError(500, logresp.cause().getMessage(), response, listOrdersSpan);
                }
            });
        });
    }

    private void sendError(int statusCode, String message, HttpServerResponse response, Span span) {
        response.setStatusCode(statusCode).end(message);
        if (span != null) {
            span.setTag("fault", message == null ? Integer.toString(statusCode) : message);
            span.finish();
        }
    }
}

