/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.app.vertx.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.tests.app.vertx.opentracing.VertxMessageExtractAdapter;

public class OrderLog {
    private Map<String, JsonArray> orders = new HashMap<String, JsonArray>();
    private MessageConsumer<JsonObject> ordersConfirmedConsumer;
    private MessageConsumer<JsonObject> getOrdersConsumer;

    private OrderLog(EventBus eb, Tracer tracer) {
        this.initOrdersConfirmedConsumer(eb, tracer);
        this.initGetOrdersConsumer(eb, tracer);
    }

    public static OrderLog create(EventBus eb, Tracer tracer) {
        return new OrderLog(eb, tracer);
    }

    protected void initOrdersConfirmedConsumer(EventBus eb, Tracer tracer) {
        this.ordersConfirmedConsumer = eb.consumer("Orders.confirmed");
        this.ordersConfirmedConsumer.handler(message -> {
            JsonObject order = (JsonObject)message.body();
            SpanContext spanCtx = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(order));
            try (Span orderConfirmedSpan = tracer.buildSpan("StoreOrder").asChildOf(spanCtx).withTag("service", "OrderLog").start();
                 Span storeOrderSpan = tracer.buildSpan("WriteOrder").asChildOf(orderConfirmedSpan).withTag("database.url", "OrdersDB").withTag("database.statement", "UPDATE Orders SET order=?").start();){
                String acctId = order.getString("accountId");
                JsonArray myOrders = this.orders.get(acctId);
                if (myOrders == null) {
                    myOrders = new JsonArray();
                    this.orders.put(acctId, myOrders);
                }
                myOrders.add(order);
            }
        });
    }

    protected void initGetOrdersConsumer(EventBus eb, Tracer tracer) {
        this.getOrdersConsumer = eb.consumer("OrderLog.getOrders");
        this.getOrdersConsumer.handler(message -> {
            JsonObject order = (JsonObject)message.body();
            SpanContext spanCtx = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(order));
            try (Span getOrdersSpan = tracer.buildSpan("GetOrders").asChildOf(spanCtx).withTag("service", "OrderLog").start();
                 Span retrieveOrdersSpan = tracer.buildSpan("RetrieveOrders").asChildOf(getOrdersSpan).withTag("database.url", "OrdersDB").withTag("database.statement", "SELECT order FROM Orders WHERE accountId = ?").start();){
                String acctId = order.getString("accountId");
                JsonArray myOrders = this.orders.get(acctId);
                if (myOrders == null) {
                    this.sendError(1, "Account not found", (Message<JsonObject>)message, getOrdersSpan);
                } else {
                    message.reply((Object)myOrders);
                }
            }
        });
    }

    private void sendError(int statusCode, String text, Message<JsonObject> message, Span span) {
        message.fail(statusCode, text);
        if (span != null) {
            span.setTag("fault", text == null ? Integer.toString(statusCode) : text);
        }
    }
}

