/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.tests.app.vertx.opentracing;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.tests.app.vertx.opentracing.VertxMessageExtractAdapter;

public class AccountManager {
    private Map<String, JsonObject> accounts = new HashMap<String, JsonObject>();
    private MessageConsumer<JsonObject> getAccountConsumer;

    private AccountManager(EventBus eb, Tracer tracer) {
        this.init(eb, tracer);
    }

    public static AccountManager create(EventBus eb, Tracer tracer) {
        return new AccountManager(eb, tracer);
    }

    protected void init(EventBus eb, Tracer tracer) {
        this.accounts.put("fred", new JsonObject().put("name", "fred"));
        this.accounts.put("joe", new JsonObject().put("name", "joe"));
        this.accounts.put("jane", new JsonObject().put("name", "jane"));
        this.accounts.put("steve", new JsonObject().put("name", "steve"));
        this.accounts.put("brian", new JsonObject().put("name", "brian"));
        this.getAccountConsumer = eb.consumer("AccountManager.getAccount");
        this.getAccountConsumer.handler(message -> {
            block27: {
                JsonObject req = (JsonObject)message.body();
                SpanContext spanCtx = tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(req));
                try (Span getAccountSpan = tracer.buildSpan("GetAccount").asChildOf(spanCtx).withTag("service", "AccountManager").start();){
                    if (!req.containsKey("accountId")) {
                        this.sendError(1, "Account id missing", (Message<JsonObject>)message, getAccountSpan);
                        break block27;
                    }
                    try (Span retrieveAccountSpan = tracer.buildSpan("RetrieveAccount").asChildOf(getAccountSpan).withTag("database.url", "AccountsDB").withTag("database.statement", "SELECT account FROM Accounts WHERE id = ?").start();){
                        JsonObject acct = this.accounts.get(req.getString("accountId"));
                        if (acct == null) {
                            this.sendError(2, "Not account found", (Message<JsonObject>)message, getAccountSpan);
                        } else {
                            message.reply((Object)acct);
                        }
                    }
                }
            }
        });
    }

    private void sendError(int statusCode, String text, Message<JsonObject> message, Span span) {
        message.fail(statusCode, text);
        if (span != null) {
            span.setTag("fault", text == null ? Integer.toString(statusCode) : text);
        }
    }
}

