/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.swarm.bootstrap.env;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;

public class WildFlySwarmManifest {
    public static final String CLASSPATH_LOCATION = "META-INF/wildfly-swarm-manifest.yaml";
    private String asset = null;
    private List<String> bootstrapModules = new ArrayList<String>();
    private List<String> bootstrapArtifacts = new ArrayList<String>();
    private List<String> dependencies = new ArrayList<String>();
    private Properties properties = new Properties();
    private Boolean bundleDependencies;
    private String mainClass = "org.wildfly.swarm.Swarm";
    private boolean hollow;

    public WildFlySwarmManifest() {
    }

    public WildFlySwarmManifest(URL url) throws IOException {
        this.read(url);
    }

    public WildFlySwarmManifest(InputStream in) throws IOException {
        this.read(in);
    }

    public void read(URL url) throws IOException {
        try (InputStream in = url.openStream();){
            this.read(in);
        }
    }

    public void read(InputStream in) throws IOException {
        Yaml yaml = new Yaml();
        Map data = (Map)yaml.load(in);
        this.asset = (String)data.get("asset");
        this.mainClass = (String)data.get("main-class");
        this.hollow = (Boolean)data.get("hollow");
        this.properties.clear();
        this.properties.putAll((Map<?, ?>)((Map)data.get("properties")));
        this.bootstrapModules.clear();
        this.bootstrapModules.addAll((Collection)data.get("modules"));
        this.bootstrapArtifacts.clear();
        this.bootstrapArtifacts.addAll((Collection)data.get("bootstrap-artifacts"));
        if (data.get("bundle-dependencies") != null) {
            this.bundleDependencies = (boolean)((Boolean)data.get("bundle-dependencies"));
        }
        this.dependencies.clear();
        this.dependencies.addAll((Collection)data.get("dependencies"));
        this.setupProperties();
    }

    public void write(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (FileWriter out = new FileWriter(path.toFile());){
            out.write(this.toString());
        }
    }

    public String toString() {
        LinkedHashMap data = new LinkedHashMap(){
            {
                if (WildFlySwarmManifest.this.asset != null) {
                    this.put("asset", WildFlySwarmManifest.this.asset);
                }
                this.put("main-class", WildFlySwarmManifest.this.mainClass);
                this.put("hollow", WildFlySwarmManifest.this.hollow);
                this.put("properties", WildFlySwarmManifest.this.properties);
                this.put("modules", WildFlySwarmManifest.this.bootstrapModules);
                this.put("bootstrap-artifacts", WildFlySwarmManifest.this.bootstrapArtifacts);
                this.put("bundle-dependencies", WildFlySwarmManifest.this.bundleDependencies);
                this.put("dependencies", WildFlySwarmManifest.this.dependencies);
            }
        };
        DumperOptions options = new DumperOptions();
        options.setPrettyFlow(true);
        options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK);
        Yaml yaml = new Yaml(options);
        return yaml.dump(data);
    }

    protected void setupProperties() {
        Enumeration<?> names = this.properties.propertyNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            Object value = this.properties.get(name);
            if (value == null || System.getProperty(name) != null) continue;
            System.setProperty(name, value.toString());
        }
        if (this.bundleDependencies != null && this.bundleDependencies.booleanValue()) {
            System.setProperty("swarm.bundled.dependencies", this.bundleDependencies.toString());
        }
    }

    public void addBootstrapModule(String module) {
        this.bootstrapModules.add(module);
    }

    public List<String> bootstrapModules() {
        return this.bootstrapModules;
    }

    public void addBootstrapArtifact(String artifact) {
        this.bootstrapArtifacts.add(artifact);
    }

    public List<String> bootstrapArtifacts() {
        return this.bootstrapArtifacts;
    }

    public void addDependency(String gav) {
        this.dependencies.add(gav);
    }

    public List<String> getDependencies() {
        return this.dependencies;
    }

    public void setAsset(String asset) {
        if (!this.isHollow()) {
            this.asset = asset;
        }
    }

    public String getAsset() {
        return this.asset;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void bundleDependencies(boolean bundleDependencies) {
        this.bundleDependencies = bundleDependencies;
    }

    public boolean isBundleDependencies() {
        if (this.bundleDependencies == null) {
            return true;
        }
        return this.bundleDependencies;
    }

    public void setMainClass(String mainClass) {
        if (mainClass != null) {
            this.mainClass = mainClass;
        }
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public void setHollow(boolean hollow) {
        this.hollow = hollow;
        if (this.isHollow()) {
            this.asset = null;
        }
    }

    public boolean isHollow() {
        return this.hollow;
    }
}

