/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.processor.tracecompletiontime;

import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.server.api.services.CommunicationDetailsCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.processor.tracecompletiontime.TraceCompletionInformation;

public class TraceCompletionInformationProcessor
extends AbstractProcessor<TraceCompletionInformation, TraceCompletionInformation> {
    private static final Logger log = Logger.getLogger(TraceCompletionInformationProcessor.class.getName());
    private static final long DEFAULT_DELAY = 500L;
    @Inject
    private CommunicationDetailsCache communicationDetailsCache;

    public TraceCompletionInformationProcessor() {
        super(Processor.ProcessorType.OneToOne);
    }

    public long getDeliveryDelay(List<TraceCompletionInformation> results) {
        return 500L;
    }

    public CommunicationDetailsCache getCommunicationDetailsCache() {
        return this.communicationDetailsCache;
    }

    public void setCommunicationDetailsCache(CommunicationDetailsCache communicationDetailsCache) {
        this.communicationDetailsCache = communicationDetailsCache;
    }

    public TraceCompletionInformation processOneToOne(String tenantId, TraceCompletionInformation item) throws RetryAttemptException {
        if (!item.getCommunications().isEmpty()) {
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < item.getCommunications().size(); ++i) {
                TraceCompletionInformation.Communication c = item.getCommunications().get(i);
                if (c.getExpire() < currentTime) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("Completion info " + item + ": communication expired = " + c);
                    }
                    if (c.isMultipleConsumers()) {
                        for (int j = 0; j < c.getIds().size(); ++j) {
                            List cds = this.communicationDetailsCache.getById(tenantId, c.getIds().get(j));
                            if (log.isLoggable(Level.FINEST)) {
                                log.finest("Multiconsumer comms details: id = " + c.getIds().get(j) + " communication details = " + cds);
                            }
                            for (int k = 0; k < cds.size(); ++k) {
                                this.processCommunication(tenantId, item, c, (CommunicationDetails)cds.get(k));
                            }
                        }
                    }
                    item.getCommunications().remove(i);
                    --i;
                    continue;
                }
                if (c.isMultipleConsumers()) continue;
                CommunicationDetails cd = null;
                for (int j = 0; cd == null && j < c.getIds().size(); ++j) {
                    cd = (CommunicationDetails)this.communicationDetailsCache.get(tenantId, c.getIds().get(j));
                }
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Completion info " + item + ": communication details for communication " + c + " = " + cd);
                }
                if (cd == null) continue;
                this.processCommunication(tenantId, item, c, cd);
                item.getCommunications().remove(i);
                --i;
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Updated completion information = " + item);
            }
            return item;
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("No communications to be processed for completion information = " + item);
        }
        return null;
    }

    protected void processCommunication(String tenantId, TraceCompletionInformation item, TraceCompletionInformation.Communication c, CommunicationDetails cd) {
        long targetFragmentBaseDuration = c.getBaseDuration() + cd.getLatency();
        long durationWithTargetFragment = targetFragmentBaseDuration + cd.getTargetFragmentDuration();
        if (durationWithTargetFragment > item.getCompletionTime().getDuration()) {
            item.getCompletionTime().setDuration(durationWithTargetFragment);
        }
        if (!cd.getProperties().isEmpty()) {
            item.getCompletionTime().getProperties().addAll(cd.getProperties());
        }
        for (int j = 0; j < cd.getOutbound().size(); ++j) {
            CommunicationDetails.Outbound ob = (CommunicationDetails.Outbound)cd.getOutbound().get(j);
            TraceCompletionInformation.Communication newc = new TraceCompletionInformation.Communication();
            newc.setIds(ob.getLinkIds());
            newc.setMultipleConsumers(ob.isMultiConsumer());
            newc.setBaseDuration(targetFragmentBaseDuration + ob.getProducerOffset());
            long baseTimeStamp = ob.isMultiConsumer() ? TimeUnit.MICROSECONDS.toMillis(cd.getTimestamp()) : System.currentTimeMillis();
            newc.setExpire(baseTimeStamp + 4000L);
            if (log.isLoggable(Level.FINEST)) {
                log.finest("Completion info " + item + ": new communication = " + newc);
            }
            item.getCommunications().add(newc);
        }
    }
}

