/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.RangeQueryBuilder;
import org.hawkular.apm.api.model.events.CompletionTime;
import org.hawkular.apm.api.model.events.NodeDetails;
import org.hawkular.apm.api.model.trace.CorrelationIdentifier;
import org.hawkular.apm.api.services.Criteria;

public class ElasticsearchUtil {
    public static final String TIMESTAMP_FIELD = "timestamp";
    public static final String DURATION_FIELD = "duration";
    public static final String NODES_FIELD = "nodes";
    public static final String URI_FIELD = "uri";
    public static final String OPERATION_FIELD = "operation";
    public static final String TRACE_ID_FIELD = "traceId";
    public static final String FRAGMENT_ID_FIELD = "fragmentId";
    public static final String TYPE_FIELD = "type";
    public static final String COMPONENT_TYPE_FIELD = "componentType";
    public static final String HOST_NAME_FIELD = "hostName";
    public static final String HOST_ADDRESS_FIELD = "hostAddress";
    public static final String TRANSACTION_FIELD = "transaction";
    public static final String PROPERTIES_FIELD = "properties";
    public static final String PROPERTIES_NAME_FIELD = "properties.name";
    public static final String PROPERTIES_VALUE_FIELD = "properties.value";
    public static final String PROPERTIES_NUMBER_FIELD = "properties.number";
    public static final String ELAPSED_FIELD = "elapsed";
    public static final String ACTUAL_FIELD = "actual";
    public static final String LATENCY_FIELD = "latency";
    public static final String SOURCE_FIELD = "source";
    public static final String TARGET_FIELD = "target";

    public static BoolQueryBuilder buildQuery(Criteria criteria, String txnProperty, Class<?> targetClass) {
        BoolQueryBuilder query = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.rangeQuery((String)TIMESTAMP_FIELD).from(TimeUnit.MILLISECONDS.toMicros(criteria.calculateStartTime())).to(TimeUnit.MILLISECONDS.toMicros(criteria.calculateEndTime())));
        if (criteria.getTransaction() != null && !criteria.getTransaction().trim().isEmpty()) {
            query = query.must((QueryBuilder)QueryBuilders.termQuery((String)txnProperty, (String)criteria.getTransaction()));
        }
        if (!criteria.getProperties().isEmpty()) {
            for (Criteria.PropertyCriteria pc : criteria.getProperties()) {
                if (pc.getOperator() == Criteria.Operator.HAS || pc.getOperator() == Criteria.Operator.HASNOT || pc.getOperator() == Criteria.Operator.EQ || pc.getOperator() == Criteria.Operator.NE) {
                    BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)PROPERTIES_NAME_FIELD, (Object)pc.getName())).must((QueryBuilder)QueryBuilders.matchQuery((String)PROPERTIES_VALUE_FIELD, (Object)pc.getValue()));
                    if (pc.getOperator() == Criteria.Operator.HASNOT || pc.getOperator() == Criteria.Operator.NE) {
                        query = query.mustNot((QueryBuilder)QueryBuilders.nestedQuery((String)PROPERTIES_FIELD, (QueryBuilder)nestedQuery));
                        continue;
                    }
                    query = query.must((QueryBuilder)QueryBuilders.nestedQuery((String)PROPERTIES_FIELD, (QueryBuilder)nestedQuery));
                    continue;
                }
                RangeQueryBuilder rangeQuery = null;
                if (pc.getOperator() == Criteria.Operator.GTE) {
                    rangeQuery = QueryBuilders.rangeQuery((String)PROPERTIES_NUMBER_FIELD).gte(pc.getValue());
                } else if (pc.getOperator() == Criteria.Operator.GT) {
                    rangeQuery = QueryBuilders.rangeQuery((String)PROPERTIES_NUMBER_FIELD).gt(pc.getValue());
                } else if (pc.getOperator() == Criteria.Operator.LTE) {
                    rangeQuery = QueryBuilders.rangeQuery((String)PROPERTIES_NUMBER_FIELD).lte(pc.getValue());
                } else if (pc.getOperator() == Criteria.Operator.LT) {
                    rangeQuery = QueryBuilders.rangeQuery((String)PROPERTIES_NUMBER_FIELD).lt(pc.getValue());
                } else {
                    throw new IllegalArgumentException("Unknown property criteria operator: " + pc);
                }
                BoolQueryBuilder nestedQuery = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.matchQuery((String)PROPERTIES_NAME_FIELD, (Object)pc.getName())).must((QueryBuilder)rangeQuery);
                query = query.must((QueryBuilder)QueryBuilders.nestedQuery((String)PROPERTIES_FIELD, (QueryBuilder)nestedQuery));
            }
        }
        if (criteria.getHostName() != null && !criteria.getHostName().trim().isEmpty()) {
            query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)HOST_NAME_FIELD, (Object)criteria.getHostName()));
        }
        if (!criteria.getCorrelationIds().isEmpty()) {
            for (CorrelationIdentifier id : criteria.getCorrelationIds()) {
                query.must((QueryBuilder)QueryBuilders.termQuery((String)"value", (String)id.getValue()));
            }
        }
        if (criteria.getLowerBound() > 0L || criteria.getUpperBound() > 0L) {
            RangeQueryBuilder rangeQuery = QueryBuilders.rangeQuery((String)DURATION_FIELD);
            if (criteria.getLowerBound() > 0L) {
                rangeQuery.gte(criteria.getLowerBound());
            }
            if (criteria.getUpperBound() > 0L) {
                rangeQuery.lte(criteria.getUpperBound());
            }
            query = query.must((QueryBuilder)rangeQuery);
        }
        if (targetClass == NodeDetails.class || targetClass == CompletionTime.class) {
            if (criteria.getUri() != null && !criteria.getUri().trim().isEmpty()) {
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)URI_FIELD, (Object)criteria.getUri()));
            }
            if (criteria.getOperation() != null && !criteria.getOperation().trim().isEmpty()) {
                query = query.must((QueryBuilder)QueryBuilders.matchQuery((String)OPERATION_FIELD, (Object)criteria.getOperation()));
            }
        }
        return query;
    }

    public static FilterBuilder buildFilter(Criteria criteria) {
        if (criteria.getTransaction() != null && criteria.getTransaction().trim().isEmpty()) {
            return FilterBuilders.missingFilter((String)TRANSACTION_FIELD);
        }
        return null;
    }
}

