/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Clock;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.delete.DeleteRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.indices.IndexMissingException;
import org.elasticsearch.search.SearchHit;
import org.hawkular.apm.api.model.Severity;
import org.hawkular.apm.api.model.config.CollectorConfiguration;
import org.hawkular.apm.api.model.config.txn.ConfigMessage;
import org.hawkular.apm.api.model.config.txn.TransactionConfig;
import org.hawkular.apm.api.model.config.txn.TransactionSummary;
import org.hawkular.apm.api.services.AbstractConfigurationService;
import org.hawkular.apm.api.services.ConfigurationLoader;
import org.hawkular.apm.server.elasticsearch.ElasticsearchClient;
import org.hawkular.apm.server.elasticsearch.log.MsgLogger;

public class ConfigurationServiceElasticsearch
extends AbstractConfigurationService {
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private static final String TXN_CONFIG_TYPE = "transactionconfig";
    private static final String TXN_CONFIG_INVALID_TYPE = "transactionconfiginvalid";
    private static final ObjectMapper mapper = new ObjectMapper();
    private ElasticsearchClient client = ElasticsearchClient.getSingleton();
    private static int DEFAULT_RESPONSE_SIZE = 100000;
    private static long DEFAULT_TIMEOUT = 10000L;
    private long timeout = DEFAULT_TIMEOUT;
    private int maxResponseSize = DEFAULT_RESPONSE_SIZE;
    private final Clock clock;

    public ConfigurationServiceElasticsearch(Clock clock) {
        this.clock = clock;
    }

    public ConfigurationServiceElasticsearch() {
        this.clock = Clock.systemDefaultZone();
    }

    public ElasticsearchClient getElasticsearchClient() {
        return this.client;
    }

    public void setElasticsearchClient(ElasticsearchClient client) {
        this.client = client;
    }

    public CollectorConfiguration getCollector(String tenantId, String type, String host, String server) {
        CollectorConfiguration config;
        block6: {
            config = ConfigurationLoader.getConfiguration((String)type);
            try {
                String index = this.client.getIndex(tenantId);
                RefreshRequestBuilder refreshRequestBuilder = this.client.getClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        TransactionConfig btc = (TransactionConfig)mapper.readValue(searchHitFields.getSourceAsString(), TransactionConfig.class);
                        if (btc.isDeleted()) continue;
                        config.getTransactions().put(searchHitFields.getId(), btc);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve transaction configs", new Object[0]);
            }
        }
        return config;
    }

    public List<ConfigMessage> setTransaction(String tenantId, String name, TransactionConfig config) throws Exception {
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Update transaction config with name[%s] config=%s", name, config);
        }
        List messages = this.validateTransaction(config);
        config.setLastUpdated(this.clock.millis());
        String index = messages.isEmpty() ? TXN_CONFIG_TYPE : TXN_CONFIG_INVALID_TYPE;
        IndexRequestBuilder builder = this.client.getClient().prepareIndex(this.client.getIndex(tenantId), index, name).setRouting(name).setSource(mapper.writeValueAsString((Object)config));
        builder.execute().actionGet();
        if (messages.isEmpty()) {
            ConfigMessage cm = new ConfigMessage();
            cm.setSeverity(Severity.Info);
            cm.setMessage("Configuration successfully published");
            messages.add(cm);
            DeleteRequestBuilder deletion = this.client.getClient().prepareDelete(this.client.getIndex(tenantId), TXN_CONFIG_INVALID_TYPE, name);
            deletion.execute().actionGet();
        } else {
            ConfigMessage cm = new ConfigMessage();
            cm.setSeverity(Severity.Warning);
            cm.setMessage("Configuration has not been published due to previous errors and/or warnings");
            messages.add(cm);
        }
        return messages;
    }

    public TransactionConfig getTransaction(String tenantId, String name) {
        TransactionConfig ret;
        block8: {
            ret = null;
            if (this.msgLog.isTraceEnabled()) {
                this.msgLog.tracef("Get transaction config with name[%s]", name);
            }
            try {
                String index = this.client.getIndex(tenantId);
                RefreshRequestBuilder refreshRequestBuilder = this.client.getClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                GetResponse response = (GetResponse)this.client.getClient().prepareGet(index, TXN_CONFIG_INVALID_TYPE, name).setRouting(name).execute().actionGet();
                if (response.isSourceEmpty()) {
                    response = (GetResponse)this.client.getClient().prepareGet(index, TXN_CONFIG_TYPE, name).setRouting(name).execute().actionGet();
                }
                if (response.isSourceEmpty()) break block8;
                try {
                    ret = (TransactionConfig)mapper.readValue(response.getSourceAsString(), TransactionConfig.class);
                    if (ret.isDeleted()) {
                        ret = null;
                    }
                }
                catch (Exception e) {
                    this.msgLog.errorFailedToParse(e);
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block8;
                this.msgLog.tracef("No index found, so unable to retrieve transaction config [%s]", name);
            }
        }
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Get transaction config with name[%s] is: %s", name, ret);
        }
        return ret;
    }

    public List<TransactionSummary> getTransactionSummaries(String tenantId) {
        ArrayList<TransactionSummary> ret;
        block10: {
            ret = new ArrayList<TransactionSummary>();
            String index = this.client.getIndex(tenantId);
            try {
                TransactionSummary summary;
                TransactionConfig config;
                RefreshRequestBuilder refreshRequestBuilder = this.client.getClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                ArrayList<String> names = new ArrayList<String>();
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        config = (TransactionConfig)mapper.readValue(searchHitFields.getSourceAsString(), TransactionConfig.class);
                        if (config.isDeleted()) continue;
                        summary = new TransactionSummary();
                        summary.setName(searchHitFields.getId());
                        summary.setDescription(config.getDescription());
                        summary.setLevel(config.getLevel());
                        ret.add(summary);
                        names.add(summary.getName());
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
                response = (SearchResponse)this.client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{TXN_CONFIG_INVALID_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        config = (TransactionConfig)mapper.readValue(searchHitFields.getSourceAsString(), TransactionConfig.class);
                        if (names.contains(searchHitFields.getId())) continue;
                        summary = new TransactionSummary();
                        summary.setName(searchHitFields.getId());
                        summary.setDescription(config.getDescription());
                        summary.setLevel(config.getLevel());
                        ret.add(summary);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block10;
                this.msgLog.tracef("No index found, so unable to retrieve transaction summaries", new Object[0]);
            }
        }
        return ret;
    }

    public Map<String, TransactionConfig> getTransactions(String tenantId, long updated) {
        HashMap<String, TransactionConfig> ret;
        block6: {
            ret = new HashMap<String, TransactionConfig>();
            String index = this.client.getIndex(tenantId);
            try {
                RefreshRequestBuilder refreshRequestBuilder = this.client.getClient().admin().indices().prepareRefresh(new String[]{index});
                this.client.getClient().admin().indices().refresh((RefreshRequest)refreshRequestBuilder.request()).actionGet();
                SearchResponse response = (SearchResponse)this.client.getClient().prepareSearch(new String[]{index}).setTypes(new String[]{TXN_CONFIG_TYPE}).setSearchType(SearchType.DFS_QUERY_THEN_FETCH).setTimeout(TimeValue.timeValueMillis((long)this.timeout)).setSize(this.maxResponseSize).setQuery((QueryBuilder)QueryBuilders.matchAllQuery()).execute().actionGet();
                if (response.isTimedOut()) {
                    this.msgLog.warnQueryTimedOut();
                }
                for (SearchHit searchHitFields : response.getHits()) {
                    try {
                        TransactionConfig btxn = (TransactionConfig)mapper.readValue(searchHitFields.getSourceAsString(), TransactionConfig.class);
                        if ((updated != 0L || btxn.isDeleted()) && (updated <= 0L || btxn.getLastUpdated() <= updated)) continue;
                        ret.put(searchHitFields.getId(), btxn);
                    }
                    catch (Exception e) {
                        this.msgLog.errorFailedToParse(e);
                    }
                }
            }
            catch (IndexMissingException t) {
                if (!this.msgLog.isTraceEnabled()) break block6;
                this.msgLog.tracef("No index found, so unable to retrieve transaction names", new Object[0]);
            }
        }
        return ret;
    }

    public void removeTransaction(String tenantId, String name) throws Exception {
        TransactionConfig config = new TransactionConfig();
        config.setDeleted(true);
        config.setLastUpdated(this.clock.millis());
        IndexRequestBuilder builder = this.client.getClient().prepareIndex(this.client.getIndex(tenantId), TXN_CONFIG_TYPE, name).setRouting(name).setSource(mapper.writeValueAsString((Object)config));
        builder.execute().actionGet();
        DeleteRequestBuilder deletion = this.client.getClient().prepareDelete(this.client.getIndex(tenantId), TXN_CONFIG_INVALID_TYPE, name);
        deletion.execute().actionGet();
        if (this.msgLog.isTraceEnabled()) {
            this.msgLog.tracef("Remove transaction config with name[%s]", name);
        }
    }

    public void clear(String tenantId) {
        this.client.clearTenant(tenantId);
    }
}

