/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.processor.zipkin;

import java.net.URL;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.events.CommunicationDetails;
import org.hawkular.apm.api.model.events.ProducerInfo;
import org.hawkular.apm.api.utils.EndpointUtil;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.services.SpanCache;
import org.hawkular.apm.server.api.task.AbstractProcessor;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;
import org.hawkular.apm.server.api.utils.ProducerInfoUtil;
import org.hawkular.apm.server.api.utils.zipkin.SpanDeriverUtil;

public class CommunicationDetailsDeriver
extends AbstractProcessor<Span, CommunicationDetails> {
    private static final Logger log = Logger.getLogger(CommunicationDetailsDeriver.class.getName());
    @Inject
    private SpanCache spanCache;

    public CommunicationDetailsDeriver() {
        super(Processor.ProcessorType.OneToOne);
    }

    public CommunicationDetailsDeriver(SpanCache cache) {
        this();
        this.spanCache = cache;
    }

    public boolean isReportRetryExpirationAsWarning() {
        return false;
    }

    public CommunicationDetails processOneToOne(String tenantId, Span item) throws RetryAttemptException {
        CommunicationDetails ret = null;
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derive communication details for span: " + item);
        }
        if (item.serverSpan()) {
            ProducerInfo pi = ProducerInfoUtil.getProducerInfo((String)tenantId, (Span)item, (SpanCache)this.spanCache);
            if (pi != null) {
                ret = new CommunicationDetails();
                ret.setId(item.getId());
                ret.setSource(EndpointUtil.encodeEndpoint((String)pi.getSourceUri(), (String)pi.getSourceOperation()));
                URL url = item.url();
                String op = SpanDeriverUtil.deriveOperation((Span)item);
                if (url != null) {
                    ret.setTarget(EndpointUtil.encodeEndpoint((String)url.getPath(), (String)op));
                } else {
                    log.warning("NO URL");
                }
                long diff = pi.getDuration() - TimeUnit.MILLISECONDS.convert(item.getDuration(), TimeUnit.MICROSECONDS);
                if (diff > 0L) {
                    ret.setLatency(diff / 2L);
                } else if (diff < 0L && log.isLoggable(Level.FINEST)) {
                    log.finest("WARNING: Negative latency for consumer = " + item);
                }
                ret.setProducerDuration(pi.getDuration());
                ret.setConsumerDuration(TimeUnit.MILLISECONDS.convert(item.getDuration(), TimeUnit.MICROSECONDS));
                ret.setMultiConsumer(pi.isMultipleConsumers());
                ret.getProperties().addAll(item.binaryAnnotationMapping().getProperties());
                ret.getProperties().addAll(pi.getProperties());
                if (item.service() != null) {
                    ret.getProperties().add(new Property("service", item.service()));
                }
                ret.setSourceFragmentId(pi.getFragmentId());
                ret.setSourceHostName(pi.getHostName());
                ret.setSourceHostAddress(pi.getHostAddress());
                ret.setTargetFragmentId(item.getId());
                ret.setTargetHostAddress(item.ipv4());
                ret.setTimestamp(pi.getTimestamp());
                long timestampOffset = item.getTimestamp() - pi.getTimestamp() - ret.getLatency();
                ret.setTimestampOffset(timestampOffset);
            } else {
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("WARNING: Producer information not available [id checked = " + item.getId() + "]");
                }
                throw new RetryAttemptException("Producer information not available [id checked = " + item.getId() + "]");
            }
        }
        if (log.isLoggable(Level.FINEST)) {
            log.finest("Derived communication details: " + ret);
        }
        return ret;
    }
}

