/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.examples.vertx.opentracing.orderlog;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.hawkular.apm.client.opentracing.APMTracer;
import org.hawkular.apm.examples.vertx.opentracing.common.VertxMessageExtractAdapter;

public class OrderLogVerticle
extends AbstractVerticle {
    private static final Logger logger = Logger.getLogger(OrderLogVerticle.class.getName());
    private Tracer tracer = new APMTracer();
    private Map<String, JsonArray> orders = new HashMap<String, JsonArray>();

    public static void main(String[] args) {
        logger.info("Starting [OrderLogVerticle] from its `main` method. Consider starting it from vertx.");
        Vertx vertx = Vertx.vertx();
        vertx.deployVerticle((Verticle)new OrderLogVerticle());
    }

    public void start(Future<Void> startFuture) throws Exception {
        logger.info("Starting Order Log");
        this.setupConsumers();
    }

    private void setupConsumers() {
        logger.info("Setting up consumers");
        this.getVertx().eventBus().consumer("joined").handler(message -> logger.info(String.format("Acknowledging that %s just joined", message.body())));
        MessageConsumer ordersConfirmedConsumer = this.getVertx().eventBus().consumer("Orders.confirmed");
        MessageConsumer getOrdersConsumer = this.getVertx().eventBus().consumer("OrderLog.getOrders");
        getOrdersConsumer.handler(message -> {
            JsonObject order = (JsonObject)message.body();
            SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(order));
            try (Span getOrdersSpan = this.tracer.buildSpan("GetOrders").asChildOf(spanCtx).start();
                 Span ignored = this.tracer.buildSpan("RetrieveOrders").asChildOf(getOrdersSpan).withTag("database.url", "OrdersDB").withTag("database.statement", "SELECT order FROM Orders WHERE accountId = ?").start();){
                String acctId = order.getString("accountId");
                JsonArray myOrders = this.orders.get(acctId);
                if (myOrders == null) {
                    this.sendError(1, "Account not found", (Message<JsonObject>)message, getOrdersSpan);
                } else {
                    message.reply((Object)myOrders);
                }
            }
        }).completionHandler(result -> {
            if (result.succeeded()) {
                this.getVertx().eventBus().send("joined", (Object)"OrderLog.getOrders");
                logger.info("Registration has completed.");
            } else {
                logger.warning("Could not register: " + result.cause().getMessage());
            }
        });
        ordersConfirmedConsumer.handler(message -> {
            JsonObject order = (JsonObject)message.body();
            SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(order));
            try (Span orderConfirmedSpan = this.tracer.buildSpan("StoreOrder").asChildOf(spanCtx).start();
                 Span ignored = this.tracer.buildSpan("WriteOrder").asChildOf(orderConfirmedSpan).withTag("database.url", "OrdersDB").withTag("database.statement", "UPDATE Orders SET order=?").start();){
                String acctId = order.getString("accountId");
                JsonArray myOrders = this.orders.get(acctId);
                if (myOrders == null) {
                    myOrders = new JsonArray();
                    this.orders.put(acctId, myOrders);
                }
                myOrders.add(order);
            }
        }).completionHandler(result -> {
            if (result.succeeded()) {
                this.getVertx().eventBus().send("joined", (Object)"Orders.confirmed");
                logger.info("Registration has completed.");
            } else {
                logger.warning("Could not register: " + result.cause().getMessage());
            }
        });
    }

    private void sendError(int statusCode, String text, Message<JsonObject> message, Span span) {
        message.fail(statusCode, text);
        if (span != null) {
            span.setTag("fault", text == null ? Integer.toString(statusCode) : text);
        }
    }
}

