/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.examples.vertx.opentracing.accountmanager;

import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.Future;
import io.vertx.core.Verticle;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.Message;
import io.vertx.core.eventbus.MessageConsumer;
import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import org.hawkular.apm.client.opentracing.APMTracer;
import org.hawkular.apm.examples.vertx.opentracing.common.VertxMessageExtractAdapter;

public class AccountManagerVerticle
extends AbstractVerticle {
    private Map<String, JsonObject> accounts = new HashMap<String, JsonObject>();
    private Tracer tracer = new APMTracer();
    private static final Logger logger = Logger.getLogger(AccountManagerVerticle.class.getName());

    public static void main(String[] args) {
        logger.info("Starting [AccountManagerVerticle] from its `main` method. Consider starting it from vertx.");
        Vertx vertx = Vertx.vertx();
        vertx.deployVerticle((Verticle)new AccountManagerVerticle());
    }

    public void start(Future<Void> startFuture) throws Exception {
        logger.info("Starting Account Manager");
        this.accounts.put("fred", new JsonObject().put("name", "fred"));
        this.accounts.put("joe", new JsonObject().put("name", "joe"));
        this.accounts.put("jane", new JsonObject().put("name", "jane"));
        this.accounts.put("steve", new JsonObject().put("name", "steve"));
        this.accounts.put("brian", new JsonObject().put("name", "brian"));
        this.setupConsumers();
        logger.info("Ready");
    }

    private void setupConsumers() {
        logger.info("Setting up consumers");
        this.getVertx().eventBus().consumer("joined").handler(message -> logger.info(String.format("Acknowledging that %s just joined", message.body())));
        MessageConsumer consumer = this.getVertx().eventBus().consumer("AccountManager.getAccount");
        consumer.handler(message -> {
            block27: {
                logger.finest("Handling message");
                JsonObject req = (JsonObject)message.body();
                SpanContext spanCtx = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new VertxMessageExtractAdapter(req));
                try (Span getAccountSpan = this.tracer.buildSpan("GetAccount").asChildOf(spanCtx).start();){
                    if (!req.containsKey("accountId")) {
                        logger.warning("Account ID is missing");
                        this.sendError(1, "Account id missing", (Message<JsonObject>)message, getAccountSpan);
                        break block27;
                    }
                    try (Span ignored = this.tracer.buildSpan("RetrieveAccount").asChildOf(getAccountSpan).withTag("database.url", "AccountsDB").withTag("database.statement", "SELECT account FROM Accounts WHERE id = ?").start();){
                        JsonObject acct = this.accounts.get(req.getString("accountId"));
                        if (acct == null) {
                            logger.warning("Account not found");
                            this.sendError(2, "Not account found", (Message<JsonObject>)message, getAccountSpan);
                        } else {
                            logger.fine("Account found, replying");
                            message.reply((Object)acct);
                        }
                    }
                }
            }
        }).completionHandler(result -> {
            if (result.succeeded()) {
                this.getVertx().eventBus().send("joined", (Object)"AccountManager.getAccount");
                logger.info("Registration has completed.");
            } else {
                logger.warning("Could not register: " + result.cause().getMessage());
            }
        });
    }

    private void sendError(int statusCode, String text, Message<JsonObject> message, Span span) {
        logger.warning("Failing message");
        message.fail(statusCode, text);
        if (span != null) {
            span.setTag("fault", text == null ? Integer.toString(statusCode) : text);
        }
    }
}

