/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.opentracing;

import org.hawkular.apm.api.model.Property;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.client.api.recorder.TraceRecorder;
import org.hawkular.apm.client.opentracing.DeploymentMetaData;

public class EnvironmentAwareTraceRecorder
implements TraceRecorder {
    private TraceRecorder backingTraceRecorder;
    private DeploymentMetaData deploymentMetaData;

    public EnvironmentAwareTraceRecorder(TraceRecorder backingTraceRecorder, DeploymentMetaData deploymentMetaData) {
        this.deploymentMetaData = deploymentMetaData;
        this.backingTraceRecorder = backingTraceRecorder;
    }

    public void record(Trace trace) {
        if (trace.getNodes() != null && trace.getNodes().size() > 0) {
            Node rootNode = (Node)trace.getNodes().get(0);
            if (this.deploymentMetaData != null) {
                if (this.deploymentMetaData.getServiceName() != null && !rootNode.hasProperty("service")) {
                    rootNode.getProperties().add(new Property("service", (Object)this.deploymentMetaData.getServiceName()));
                }
                if (this.deploymentMetaData.getBuildStamp() != null && !rootNode.hasProperty("buildStamp")) {
                    rootNode.getProperties().add(new Property("buildStamp", (Object)this.deploymentMetaData.getBuildStamp()));
                }
            }
        }
        this.backingTraceRecorder.record(trace);
    }

    public DeploymentMetaData getDeploymentMetaData() {
        return this.deploymentMetaData;
    }
}

