/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.api.recorder;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.hawkular.apm.api.logging.Logger;
import org.hawkular.apm.api.model.trace.Trace;
import org.hawkular.apm.api.services.ServiceResolver;
import org.hawkular.apm.api.services.TracePublisher;
import org.hawkular.apm.api.utils.PropertyUtil;
import org.hawkular.apm.client.api.recorder.TraceRecorder;

public class BatchTraceRecorder
implements TraceRecorder {
    private static final Logger log = Logger.getLogger((String)BatchTraceRecorder.class.getName());
    private static final int DEFAULT_BATCH_THREAD_POOL_SIZE = 5;
    private static final int DEFAULT_BATCH_TIME = 500;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    private static final String HAWKULAR_APM_TENANT_ID = "HAWKULAR_APM_TENANTID";
    private TracePublisher tracePublisher;
    private List<Trace> traces;
    private int batchSize;
    private String tenantId;
    private ExecutorService executor;
    private final ReentrantLock lock = new ReentrantLock();

    public BatchTraceRecorder() {
        this(BatchTraceRecorderBuilder.fromEnvProperties());
    }

    public BatchTraceRecorder(BatchTraceRecorderBuilder recorderBuilder) {
        this.init(recorderBuilder);
    }

    protected void init(BatchTraceRecorderBuilder builder) {
        this.tracePublisher = builder.tracePublisher;
        this.tenantId = builder.tenantId;
        this.batchSize = builder.batchSize;
        this.traces = new ArrayList<Trace>(this.batchSize + 1);
        Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        }).scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                if (!BatchTraceRecorder.this.traces.isEmpty()) {
                    try {
                        BatchTraceRecorder.this.lock.lock();
                        BatchTraceRecorder.this.submitTraces();
                    }
                    finally {
                        BatchTraceRecorder.this.lock.unlock();
                    }
                }
            }
        }, builder.batchTime, builder.batchTime, TimeUnit.MILLISECONDS);
        this.executor = Executors.newFixedThreadPool(builder.threadPoolSize, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
    }

    public boolean isEnabled() {
        return this.tracePublisher != null;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void record(Trace trace) {
        if (this.tracePublisher != null) {
            try {
                this.lock.lock();
                this.traces.add(trace);
                if (this.traces.size() < this.batchSize) return;
                this.submitTraces();
                return;
            }
            finally {
                this.lock.unlock();
            }
        } else {
            log.warning("Trace publisher is not available!");
        }
    }

    protected void submitTraces() {
        if (!this.traces.isEmpty()) {
            final List<Trace> toSend = this.traces;
            this.traces = new ArrayList<Trace>(this.batchSize + 1);
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        BatchTraceRecorder.this.tracePublisher.publish(BatchTraceRecorder.this.tenantId, toSend);
                    }
                    catch (Exception e) {
                        log.log(Logger.Level.SEVERE, "Failed to publish traces", (Throwable)e);
                    }
                }
            });
        }
    }

    public static class BatchTraceRecorderBuilder {
        private int batchSize = 1000;
        private int batchTime = 500;
        private int threadPoolSize = 5;
        private String tenantId;
        private TracePublisher tracePublisher = (TracePublisher)ServiceResolver.getSingletonService(TracePublisher.class);

        public BatchTraceRecorderBuilder withTracePublisher(TracePublisher tracePublisher) {
            this.tracePublisher = tracePublisher;
            return this;
        }

        public BatchTraceRecorderBuilder withBatchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public BatchTraceRecorderBuilder withBatchTime(int batchTimeMillis) {
            this.batchTime = batchTimeMillis;
            return this;
        }

        public BatchTraceRecorderBuilder withBatchPoolSize(int threadPoolSize) {
            this.threadPoolSize = threadPoolSize;
            return this;
        }

        public BatchTraceRecorderBuilder withTenantId(String tenantId) {
            this.tenantId = tenantId;
            return this;
        }

        public BatchTraceRecorder build() {
            return new BatchTraceRecorder(this);
        }

        private static BatchTraceRecorderBuilder fromEnvProperties() {
            BatchTraceRecorderBuilder builder = new BatchTraceRecorderBuilder();
            if (PropertyUtil.getProperty((String)"HAWKULAR_APM_COLLECTOR_BATCHSIZE", null) != null) {
                String batchSize = PropertyUtil.getProperty((String)"HAWKULAR_APM_COLLECTOR_BATCHSIZE", null);
                builder.withBatchSize(Integer.parseInt(batchSize));
            }
            if (PropertyUtil.getProperty((String)"HAWKULAR_APM_COLLECTOR_BATCHTIME", null) != null) {
                String batchTime = PropertyUtil.getProperty((String)"HAWKULAR_APM_COLLECTOR_BATCHTIME", null);
                builder.withBatchTime(Integer.parseInt(batchTime));
            }
            if (PropertyUtil.getProperty((String)"HAWKULAR_APM_COLLECTOR_BATCHTHREADS", null) != null) {
                String threadPoolSize = PropertyUtil.getProperty((String)"HAWKULAR_APM_COLLECTOR_BATCHTHREADS", null);
                builder.withBatchPoolSize(Integer.parseInt(threadPoolSize));
            }
            builder.withTenantId(PropertyUtil.getProperty((String)BatchTraceRecorder.HAWKULAR_APM_TENANT_ID, null));
            return builder;
        }
    }
}

