/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2.templates.res;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import shaded.org.mvel2.MVEL;
import shaded.org.mvel2.integration.VariableResolverFactory;
import shaded.org.mvel2.templates.TemplateError;
import shaded.org.mvel2.templates.TemplateRuntime;
import shaded.org.mvel2.templates.res.Node;
import shaded.org.mvel2.templates.util.TemplateOutputStream;
import shaded.org.mvel2.templates.util.TemplateTools;

public class IncludeNode
extends Node {
    int includeStart;
    int includeOffset;
    int preStart;
    int preOffset;

    public IncludeNode(int begin, String name, char[] template, int start, int end) {
        this.begin = begin;
        this.name = name;
        this.contents = template;
        this.cStart = start;
        this.cEnd = end - 1;
        this.end = end;
        int mark = TemplateTools.captureToEOS(this.contents, 0);
        this.includeStart = this.cStart;
        this.includeOffset = mark - this.cStart;
        this.preStart = ++mark;
        this.preOffset = this.cEnd - mark;
    }

    public Object eval(TemplateRuntime runtime, TemplateOutputStream appender, Object ctx, VariableResolverFactory factory) {
        String file = MVEL.eval(this.contents, this.includeStart, this.includeOffset, ctx, factory, String.class);
        if (this.preOffset != 0) {
            MVEL.eval(this.contents, this.preStart, this.preOffset, ctx, factory);
        }
        if (this.next != null) {
            return this.next.eval(runtime, appender.append(String.valueOf(TemplateRuntime.eval(IncludeNode.readInFile(runtime, file), ctx, factory))), ctx, factory);
        }
        return appender.append(String.valueOf(MVEL.eval(IncludeNode.readInFile(runtime, file), ctx, factory)));
    }

    public boolean demarcate(Node terminatingNode, char[] template) {
        return false;
    }

    public static String readInFile(TemplateRuntime runtime, String fileName) {
        File file = new File(String.valueOf(runtime.getRelPath().peek()) + "/" + fileName);
        try {
            int read;
            FileInputStream instream = new FileInputStream(file);
            BufferedInputStream bufstream = new BufferedInputStream(instream);
            runtime.getRelPath().push(file.getParent());
            byte[] buf = new byte[10];
            StringBuilder appender = new StringBuilder();
            while ((read = bufstream.read(buf)) != -1) {
                for (int i = 0; i < read; ++i) {
                    appender.append((char)buf[i]);
                }
            }
            bufstream.close();
            instream.close();
            runtime.getRelPath().pop();
            return appender.toString();
        }
        catch (FileNotFoundException e) {
            throw new TemplateError("cannot include template '" + fileName + "': file not found.");
        }
        catch (IOException e) {
            throw new TemplateError("unknown I/O exception while including '" + fileName + "' (stacktrace nested)", e);
        }
    }
}

