/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.inject.Inject;
import shaded.org.hawkular.apm.api.model.analytics.CommunicationSummaryStatistics;
import shaded.org.hawkular.apm.api.model.analytics.EndpointInfo;
import shaded.org.hawkular.apm.api.model.config.txn.TransactionConfig;
import shaded.org.hawkular.apm.api.model.trace.Consumer;
import shaded.org.hawkular.apm.api.model.trace.ContainerNode;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.Producer;
import shaded.org.hawkular.apm.api.model.trace.Trace;
import shaded.org.hawkular.apm.api.services.AnalyticsService;
import shaded.org.hawkular.apm.api.services.ConfigurationService;
import shaded.org.hawkular.apm.api.services.Criteria;
import shaded.org.hawkular.apm.api.services.internal.CommunicationSeverityAnalyser;
import shaded.org.hawkular.apm.api.services.internal.CommunicationSummaryTreeBuilder;
import shaded.org.hawkular.apm.api.utils.EndpointUtil;

public abstract class AbstractAnalyticsService
implements AnalyticsService {
    private static final Logger log = Logger.getLogger(AbstractAnalyticsService.class.getName());
    @Inject
    private ConfigurationService configService;
    private CommunicationSeverityAnalyser communicationSeverityAnalyser = new CommunicationSeverityAnalyser();

    public ConfigurationService getConfigurationService() {
        return this.configService;
    }

    public void setConfigurationService(ConfigurationService cs) {
        this.configService = cs;
    }

    protected abstract List<Trace> getFragments(String var1, Criteria var2);

    @Override
    public List<EndpointInfo> getUnboundEndpoints(String tenantId, long startTime, long endTime, boolean compress) {
        Criteria criteria = new Criteria();
        criteria.setStartTime(startTime).setEndTime(endTime);
        List<Trace> fragments = this.getFragments(tenantId, criteria);
        return this.doGetUnboundEndpoints(tenantId, fragments, compress);
    }

    @Override
    public List<EndpointInfo> getBoundEndpoints(String tenantId, String transaction, long startTime, long endTime) {
        ArrayList<EndpointInfo> ret = new ArrayList<EndpointInfo>();
        Criteria criteria = new Criteria();
        criteria.setTransaction(transaction).setStartTime(startTime).setEndTime(endTime);
        List<Trace> fragments = this.getFragments(tenantId, criteria);
        for (int i = 0; i < fragments.size(); ++i) {
            Trace trace = fragments.get(i);
            this.obtainEndpoints(trace.getNodes(), ret);
        }
        return ret;
    }

    protected static List<EndpointInfo> compressEndpointInfo(List<EndpointInfo> endpoints) {
        ArrayList<EndpointInfo> others = new ArrayList<EndpointInfo>();
        EndpointPart rootPart = new EndpointPart();
        for (int i = 0; i < endpoints.size(); ++i) {
            EndpointInfo endpoint = endpoints.get(i);
            if (endpoint.getEndpoint() != null && endpoint.getEndpoint().length() > 1 && endpoint.getEndpoint().charAt(0) == '/') {
                String[] parts = endpoint.getEndpoint().split("/");
                AbstractAnalyticsService.buildTree(rootPart, parts, 1, endpoint.getType());
                continue;
            }
            others.add(new EndpointInfo(endpoint));
        }
        List<EndpointInfo> info = null;
        if (endpoints.size() != others.size()) {
            rootPart.collapse();
            info = AbstractAnalyticsService.extractEndpointInfo(rootPart);
            info.addAll(others);
        } else {
            info = others;
        }
        AbstractAnalyticsService.initEndpointInfo(info);
        return info;
    }

    protected static void buildTree(EndpointPart parent, String[] parts, int index, String endpointType) {
        String name = parts[index];
        String qualifier = null;
        if (index == parts.length - 1) {
            qualifier = EndpointUtil.decodeEndpointOperation(parts[index], false);
            name = EndpointUtil.decodeEndpointURI(parts[index]);
        }
        EndpointPart child = parent.addChild(name);
        if (index < parts.length - 1) {
            AbstractAnalyticsService.buildTree(child, parts, index + 1, endpointType);
        } else {
            if (qualifier != null) {
                child = child.addChild(qualifier);
                child.setQualifier(true);
            }
            child.setEndpointType(endpointType);
        }
    }

    protected static List<EndpointInfo> extractEndpointInfo(EndpointPart root) {
        ArrayList<EndpointInfo> endpoints = new ArrayList<EndpointInfo>();
        root.extractEndpointInfo(endpoints, "");
        return endpoints;
    }

    protected static void initEndpointInfo(List<EndpointInfo> endpoints) {
        for (int i = 0; i < endpoints.size(); ++i) {
            AbstractAnalyticsService.initEndpointInfo(endpoints.get(i));
        }
    }

    protected static void initEndpointInfo(EndpointInfo endpoint) {
        endpoint.setRegex(AbstractAnalyticsService.createRegex(endpoint.getEndpoint(), endpoint.metaURI()));
        String uri = EndpointUtil.decodeEndpointURI(endpoint.getEndpoint());
        if (uri != null) {
            endpoint.setUriRegex(AbstractAnalyticsService.createRegex(uri, endpoint.metaURI()));
        }
        if (uri != null && endpoint.metaURI()) {
            StringBuilder template = new StringBuilder();
            String[] parts = uri.split("/");
            String part = null;
            int paramNo = 1;
            for (int j = 1; j < parts.length; ++j) {
                template.append("/");
                if (parts[j].equals("*")) {
                    if (part == null) {
                        template.append("{");
                        template.append("param");
                        template.append(paramNo++);
                        template.append("}");
                    } else {
                        if (part.length() > 1 && part.charAt(part.length() - 1) == 's') {
                            part = part.substring(0, part.length() - 1);
                        }
                        template.append("{");
                        template.append(part);
                        template.append("Id}");
                    }
                    part = null;
                    continue;
                }
                part = parts[j];
                template.append(part);
            }
            endpoint.setUriTemplate(template.toString());
        }
    }

    @Override
    public Collection<CommunicationSummaryStatistics> getCommunicationSummaryStatistics(String tenantId, Criteria criteria, boolean asTree) {
        Collection<CommunicationSummaryStatistics> ret = this.doGetCommunicationSummaryStatistics(tenantId, criteria);
        this.communicationSeverityAnalyser.evaluateCommunicationSummarySeverity(ret);
        if (asTree) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getCommunicationSummaryStatistics (before tree) = " + ret);
            }
            ret = CommunicationSummaryTreeBuilder.buildCommunicationSummaryTree(ret, this.getEndpoints(tenantId, criteria));
            if (!criteria.transactionWide()) {
                Iterator<CommunicationSummaryStatistics> iter = ret.iterator();
                while (iter.hasNext()) {
                    CommunicationSummaryStatistics css = iter.next();
                    if (AbstractAnalyticsService.hasMetrics(css)) continue;
                    if (log.isLoggable(Level.FINEST)) {
                        log.finest("getCommunicationSummaryStatistics remove unused = " + css);
                    }
                    iter.remove();
                }
            }
            if (log.isLoggable(Level.FINEST)) {
                log.finest("getCommunicationSummaryStatistics (tree) = " + ret);
            }
        } else if (log.isLoggable(Level.FINEST)) {
            log.finest("getCommunicationSummaryStatistics (flat) = " + ret);
        }
        return ret;
    }

    protected Set<String> getEndpoints(String tenantId, Criteria criteria) {
        return this.getTraceCompletions(tenantId, criteria).stream().map(ct -> EndpointUtil.encodeEndpoint(ct.getUri(), ct.getOperation())).collect(Collectors.toSet());
    }

    protected static boolean hasMetrics(CommunicationSummaryStatistics css) {
        if (css.getCount() > 0L) {
            return true;
        }
        for (CommunicationSummaryStatistics.ConnectionStatistics cs : css.getOutbound().values()) {
            if (cs.getCount() > 0L) {
                return true;
            }
            if (cs.getNode() == null || !AbstractAnalyticsService.hasMetrics(cs.getNode())) continue;
            return true;
        }
        return false;
    }

    protected abstract Collection<CommunicationSummaryStatistics> doGetCommunicationSummaryStatistics(String var1, Criteria var2);

    protected List<EndpointInfo> doGetUnboundEndpoints(String tenantId, List<Trace> fragments, boolean compress) {
        List<EndpointInfo> ret = new ArrayList<EndpointInfo>();
        HashMap<String, EndpointInfo> map = new HashMap<String, EndpointInfo>();
        for (int i = 0; i < fragments.size(); ++i) {
            Trace trace = fragments.get(i);
            if (!trace.initialFragment() || trace.getNodes().isEmpty() || trace.getTransaction() != null) continue;
            if (trace.getNodes().get(0) instanceof Consumer) {
                Consumer consumer = (Consumer)trace.getNodes().get(0);
                String endpoint = EndpointUtil.encodeEndpoint(consumer.getUri(), consumer.getOperation());
                if (map.containsKey(endpoint) || !consumer.getProperties("fault").isEmpty()) continue;
                EndpointInfo info = new EndpointInfo();
                info.setEndpoint(endpoint);
                info.setType(consumer.getEndpointType());
                ret.add(info);
                map.put(endpoint, info);
                continue;
            }
            this.obtainProducerEndpoints(trace.getNodes(), ret, map);
        }
        if (this.configService != null) {
            Map<String, TransactionConfig> configs = this.configService.getTransactions(tenantId, 0L);
            for (TransactionConfig config : configs.values()) {
                if (config.getFilter() == null || config.getFilter().getInclusions() == null) continue;
                if (log.isLoggable(Level.FINEST)) {
                    log.finest("Remove unbound URIs associated with btxn config=" + config);
                }
                for (String filter : config.getFilter().getInclusions()) {
                    if (filter == null || filter.trim().isEmpty()) continue;
                    Iterator<EndpointInfo> iter = ret.iterator();
                    while (iter.hasNext()) {
                        EndpointInfo info = iter.next();
                        if (!Pattern.matches(filter, info.getEndpoint())) continue;
                        iter.remove();
                    }
                }
            }
        }
        if (compress) {
            ret = AbstractAnalyticsService.compressEndpointInfo(ret);
        }
        Collections.sort(ret, new Comparator<EndpointInfo>(){

            @Override
            public int compare(EndpointInfo arg0, EndpointInfo arg1) {
                return arg0.getEndpoint().compareTo(arg1.getEndpoint());
            }
        });
        return ret;
    }

    protected void obtainEndpoints(List<Node> nodes, List<EndpointInfo> endpoints) {
        for (int i = 0; i < nodes.size(); ++i) {
            Node node = nodes.get(i);
            if (node.getUri() != null) {
                EndpointInfo ei = new EndpointInfo();
                ei.setEndpoint(EndpointUtil.encodeEndpoint(node.getUri(), node.getOperation()));
                if (!endpoints.contains(ei)) {
                    AbstractAnalyticsService.initEndpointInfo(ei);
                    endpoints.add(ei);
                }
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainEndpoints(((ContainerNode)node).getNodes(), endpoints);
        }
    }

    protected void obtainProducerEndpoints(List<Node> nodes, List<EndpointInfo> endpoints, Map<String, EndpointInfo> map) {
        for (int i = 0; i < nodes.size(); ++i) {
            String endpoint;
            Node node = nodes.get(i);
            if (node instanceof Producer && !map.containsKey(endpoint = EndpointUtil.encodeEndpoint(node.getUri(), node.getOperation()))) {
                EndpointInfo info = new EndpointInfo();
                info.setEndpoint(endpoint);
                info.setType(((Producer)node).getEndpointType());
                endpoints.add(info);
                map.put(endpoint, info);
            }
            if (!(node instanceof ContainerNode)) continue;
            this.obtainProducerEndpoints(((ContainerNode)node).getNodes(), endpoints, map);
        }
    }

    protected static String createRegex(String endpoint, boolean meta) {
        StringBuilder regex = new StringBuilder();
        regex.append('^');
        for (int i = 0; i < endpoint.length(); ++i) {
            char ch = endpoint.charAt(i);
            if ("*".indexOf(ch) != -1) {
                regex.append('.');
            } else if ("\\.^$|?+[]{}()".indexOf(ch) != -1) {
                regex.append('\\');
            }
            regex.append(ch);
        }
        regex.append('$');
        return regex.toString();
    }

    public static class EndpointPart {
        private static final int CHILD_THRESHOLD = 10;
        private int count = 1;
        private Map<String, EndpointPart> children;
        private String endpointType;
        private boolean qualifier = false;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public Map<String, EndpointPart> getChildren() {
            return this.children;
        }

        public void setChildren(Map<String, EndpointPart> children) {
            this.children = children;
        }

        public EndpointPart addChild(String name) {
            EndpointPart child = null;
            if (this.children == null) {
                this.children = new HashMap<String, EndpointPart>();
            }
            if (!this.children.containsKey(name)) {
                child = new EndpointPart();
                this.children.put(name, child);
            } else {
                child = this.children.get(name);
                child.setCount(child.getCount() + 1);
            }
            return child;
        }

        public void collapse() {
            if (this.children != null && !this.children.isEmpty()) {
                if (this.children.size() >= 10) {
                    EndpointPart merged = new EndpointPart();
                    for (EndpointPart cur : this.children.values()) {
                        merged.merge(cur);
                    }
                    this.children.clear();
                    this.children.put("*", merged);
                    merged.collapse();
                } else {
                    for (EndpointPart part : this.children.values()) {
                        part.collapse();
                    }
                }
            }
        }

        public void merge(EndpointPart toMerge) {
            if (this.endpointType == null) {
                this.endpointType = toMerge.getEndpointType();
            }
            this.count += toMerge.getCount();
            if (toMerge.getChildren() != null) {
                if (this.children == null) {
                    this.children = new HashMap<String, EndpointPart>();
                }
                for (String child : toMerge.getChildren().keySet()) {
                    if (this.getChildren().containsKey(child)) {
                        this.getChildren().get(child).merge(toMerge.getChildren().get(child));
                        continue;
                    }
                    this.getChildren().put(child, toMerge.getChildren().get(child));
                }
            }
        }

        public void extractEndpointInfo(List<EndpointInfo> endpoints, String endpoint) {
            if (this.endpointType != null) {
                EndpointInfo info = new EndpointInfo();
                info.setEndpoint(endpoint);
                info.setType(this.endpointType);
                endpoints.add(info);
            }
            if (this.getChildren() != null) {
                for (String child : this.getChildren().keySet()) {
                    EndpointPart part = this.getChildren().get(child);
                    part.extractEndpointInfo(endpoints, endpoint + (part.isQualifier() ? "" : "/") + child);
                }
            }
        }

        public String getEndpointType() {
            return this.endpointType;
        }

        public void setEndpointType(String endpointType) {
            this.endpointType = endpointType;
        }

        public boolean isQualifier() {
            return this.qualifier;
        }

        public void setQualifier(boolean qualifier) {
            this.qualifier = qualifier;
        }
    }
}

