/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.model.events;

import java.io.Serializable;
import shaded.org.hawkular.apm.api.utils.EndpointUtil;

public class EndpointRef
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String uri;
    private String operation;
    private boolean client = false;

    public EndpointRef() {
    }

    public EndpointRef(String uri, String operation, boolean client) {
        this.uri = uri;
        this.operation = operation;
        this.client = client;
    }

    public final String getUri() {
        if (this.client) {
            return EndpointUtil.encodeClientURI(this.uri);
        }
        return this.uri;
    }

    public final String getOperation() {
        return this.operation;
    }

    public final boolean isClient() {
        return this.client;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.client) {
            buf.append("client:");
        }
        if (this.uri != null && !this.uri.trim().isEmpty()) {
            buf.append(this.uri);
        }
        if (this.operation != null && !this.operation.trim().isEmpty()) {
            buf.append('[');
            buf.append(this.operation);
            buf.append(']');
        }
        return buf.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.client ? 1231 : 1237);
        result = 31 * result + (this.operation == null ? 0 : this.operation.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        EndpointRef other = (EndpointRef)obj;
        if (this.client != other.client) {
            return false;
        }
        if (this.operation == null ? other.operation != null : !this.operation.equals(other.operation)) {
            return false;
        }
        return !(this.uri == null ? other.uri != null : !this.uri.equals(other.uri));
    }
}

