/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.rule.expression;

import java.io.StringWriter;
import org.jboss.byteman.rule.Rule;
import org.jboss.byteman.rule.RuleElement;
import org.jboss.byteman.rule.exception.ExecuteException;
import org.jboss.byteman.rule.exception.TypeException;
import org.jboss.byteman.rule.grammar.ParseNode;
import org.jboss.byteman.rule.helper.HelperAdapter;
import org.jboss.byteman.rule.type.Type;

public abstract class Expression
extends RuleElement {
    protected Rule rule;
    protected Type type;
    protected int charPos;
    protected int line;
    protected ParseNode token;

    protected Expression(Rule rule, Type type, ParseNode token) {
        super(rule);
        this.rule = rule;
        this.type = type;
        this.token = token;
        if (token != null) {
            this.charPos = token.getColumn();
            this.line = token.getLine();
        } else {
            this.charPos = 0;
            this.line = 0;
        }
    }

    public abstract void bind() throws TypeException;

    public String getPos() {
        return " file " + this.rule.getFile() + " line " + this.line;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public abstract Type typeCheck(Type var1) throws TypeException;

    @Override
    public abstract Object interpret(HelperAdapter var1) throws ExecuteException;

    @Override
    public abstract void writeTo(StringWriter var1);
}

