/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.instrumenter.headers;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.hawkular.apm.instrumenter.headers.HeadersAccessor;
import shaded.org.hawkular.apm.api.logging.Logger;

public class JavaxJmsHeadersAccessor
implements HeadersAccessor {
    private static final Logger log = Logger.getLogger(JavaxJmsHeadersAccessor.class.getName());
    private static final String TARGET_TYPE = "javax.jms.Message";

    @Override
    public String getTargetType() {
        return TARGET_TYPE;
    }

    @Override
    public Map<String, String> getHeaders(Object target) {
        try {
            Class<?> cls = Thread.currentThread().getContextClassLoader().loadClass(TARGET_TYPE);
            Method getHeaderNamesMethod = cls.getMethod("getPropertyNames", new Class[0]);
            Method getHeaderMethod = cls.getMethod("getStringProperty", String.class);
            HashMap<String, String> ret = new HashMap<String, String>();
            Enumeration iter = (Enumeration)getHeaderNamesMethod.invoke(target, new Object[0]);
            while (iter.hasMoreElements()) {
                String key = (String)iter.nextElement();
                try {
                    String value = (String)getHeaderMethod.invoke(target, key);
                    ret.put(key, value);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException exception) {}
            }
            return ret;
        }
        catch (Throwable t) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.log(Logger.Level.FINEST, "Failed to obtain headers", t);
            }
            return null;
        }
    }
}

