/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.client.collector.internal;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.hawkular.apm.client.collector.internal.FragmentBuilder;
import shaded.org.hawkular.apm.api.logging.Logger;

public class FragmentManager {
    private static final Logger log = Logger.getLogger(FragmentManager.class.getName());
    private ThreadLocal<FragmentBuilder> builders = new ThreadLocal();
    private AtomicInteger threadCounter = new AtomicInteger();
    private Set<String> threadNames = new HashSet<String>();

    protected int getThreadCounter() {
        return this.threadCounter.get();
    }

    public boolean hasFragmentBuilder() {
        return this.builders.get() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FragmentBuilder getFragmentBuilder() {
        FragmentBuilder builder = this.builders.get();
        if (builder == null) {
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Creating new FragmentBuilder");
            }
            builder = new FragmentBuilder();
            this.builders.set(builder);
            int currentCount = this.threadCounter.incrementAndGet();
            int builderCount = builder.incrementThreadCount();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Associate Thread with FragmentBuilder(1): Total Thread Count = " + currentCount + " : Fragment Thread Count = " + builderCount);
                Set<String> set = this.threadNames;
                synchronized (set) {
                    this.threadNames.add(Thread.currentThread().getName());
                }
            }
        }
        return builder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFragmentBuilder(FragmentBuilder builder) {
        FragmentBuilder currentBuilder = this.builders.get();
        if (currentBuilder == null && builder != null) {
            int currentCount = this.threadCounter.incrementAndGet();
            int builderCount = builder.incrementThreadCount();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Associate Thread with FragmentBuilder(2): Total Thread Count = " + currentCount + " : Fragment Thread Count = " + builderCount);
                Set<String> set = this.threadNames;
                synchronized (set) {
                    this.threadNames.add(Thread.currentThread().getName());
                }
            }
        } else if (currentBuilder != null && builder == null) {
            int currentCount = this.threadCounter.decrementAndGet();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("Disassociate Thread from FragmentBuilder(2): Total Thread Count = " + currentCount);
                Set<String> builderCount = this.threadNames;
                synchronized (builderCount) {
                    this.threadNames.remove(Thread.currentThread().getName());
                }
            }
        } else if (currentBuilder != builder) {
            int oldCount = currentBuilder.decrementThreadCount();
            int newCount = builder.incrementThreadCount();
            if (log.isLoggable(Logger.Level.FINEST)) {
                log.finest("WARNING: Overwriting thread's fragment builder: old=[" + currentBuilder + " count=" + oldCount + "] now=[" + builder + " count=" + newCount + "]");
            }
        }
        this.builders.set(builder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        FragmentBuilder currentBuilder;
        int currentCount = this.threadCounter.decrementAndGet();
        if (log.isLoggable(Logger.Level.FINEST)) {
            log.finest("Clear: Disassociate Thread from FragmentBuilder(1): current thread count=" + currentCount);
            Set<String> set = this.threadNames;
            synchronized (set) {
                this.threadNames.remove(Thread.currentThread().getName());
            }
        }
        if ((currentBuilder = this.builders.get()) != null) {
            currentBuilder.decrementThreadCount();
        }
        this.builders.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void diagnostics() {
        log.finest("Thread count = " + this.threadCounter);
        if (this.threadCounter.get() > 0) {
            log.finest("Thread names:");
            Set<String> set = this.threadNames;
            synchronized (set) {
                for (String name : this.threadNames) {
                    log.finest("\t" + name);
                }
            }
        }
    }
}

