/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.mvel2.optimizers.dynamic;

import shaded.org.mvel2.ParserContext;
import shaded.org.mvel2.compiler.Accessor;
import shaded.org.mvel2.integration.VariableResolverFactory;
import shaded.org.mvel2.optimizers.AccessorOptimizer;
import shaded.org.mvel2.optimizers.OptimizerFactory;
import shaded.org.mvel2.optimizers.dynamic.DynamicAccessor;
import shaded.org.mvel2.optimizers.dynamic.DynamicOptimizer;

public class DynamicSetAccessor
implements DynamicAccessor {
    private char[] property;
    private int start;
    private int offset;
    private boolean opt = false;
    private int runcount = 0;
    private long stamp;
    private ParserContext context;
    private final Accessor _safeAccessor;
    private Accessor _accessor;
    private String description;

    public DynamicSetAccessor(ParserContext context, char[] property, int start, int offset, Accessor _accessor) {
        assert (_accessor != null);
        this._safeAccessor = this._accessor = _accessor;
        this.context = context;
        this.property = property;
        this.start = start;
        this.offset = offset;
        this.stamp = System.currentTimeMillis();
    }

    public Object setValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory, Object value) {
        if (!this.opt && ++this.runcount > DynamicOptimizer.tenuringThreshold) {
            if (System.currentTimeMillis() - this.stamp < DynamicOptimizer.timeSpan) {
                this.opt = true;
                return this.optimize(ctx, elCtx, variableFactory, value);
            }
            this.runcount = 0;
            this.stamp = System.currentTimeMillis();
        }
        this._accessor.setValue(ctx, elCtx, variableFactory, value);
        return value;
    }

    public Object getValue(Object ctx, Object elCtx, VariableResolverFactory variableFactory) {
        throw new RuntimeException("value cannot be read with this accessor");
    }

    private Object optimize(Object ctx, Object elCtx, VariableResolverFactory variableResolverFactory, Object value) {
        if (DynamicOptimizer.isOverloaded()) {
            DynamicOptimizer.enforceTenureLimit();
        }
        AccessorOptimizer ao = OptimizerFactory.getAccessorCompiler("ASM");
        this._accessor = ao.optimizeSetAccessor(this.context, this.property, this.start, this.offset, ctx, elCtx, variableResolverFactory, false, value, value != null ? value.getClass() : Object.class);
        assert (this._accessor != null);
        return value;
    }

    public void deoptimize() {
        this._accessor = this._safeAccessor;
        this.opt = false;
        this.runcount = 0;
        this.stamp = System.currentTimeMillis();
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Class getKnownEgressType() {
        return this._safeAccessor.getKnownEgressType();
    }
}

