/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.model.events;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Set;
import shaded.org.hawkular.apm.api.model.Property;
import shaded.org.hawkular.apm.api.model.events.ApmEvent;
import shaded.org.hawkular.apm.api.model.events.EndpointRef;
import shaded.org.hawkular.apm.api.utils.SerializationUtil;

public class SourceInfo
implements Externalizable,
ApmEvent {
    private String id;
    private EndpointRef endpoint;
    private long timestamp = 0L;
    private long duration = 0L;
    private String fragmentId;
    private String hostName;
    private String hostAddress;
    private boolean multipleConsumers = false;
    private Set<Property> properties = new HashSet<Property>();

    public SourceInfo() {
    }

    public SourceInfo(SourceInfo si) {
        this.id = si.id;
        this.endpoint = si.endpoint;
        this.timestamp = si.timestamp;
        this.duration = si.duration;
        this.fragmentId = si.fragmentId;
        this.hostName = si.hostName;
        this.hostAddress = si.hostAddress;
        this.multipleConsumers = si.multipleConsumers;
        this.properties = si.properties;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EndpointRef getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(EndpointRef endpoint) {
        this.endpoint = endpoint;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public String getFragmentId() {
        return this.fragmentId;
    }

    public void setFragmentId(String fragmentId) {
        this.fragmentId = fragmentId;
    }

    public String getHostName() {
        return this.hostName;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostAddress() {
        return this.hostAddress;
    }

    public void setHostAddress(String hostAddress) {
        this.hostAddress = hostAddress;
    }

    public boolean isMultipleConsumers() {
        return this.multipleConsumers;
    }

    public void setMultipleConsumers(boolean multipleConsumers) {
        this.multipleConsumers = multipleConsumers;
    }

    public Set<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(Set<Property> properties) {
        this.properties = properties;
    }

    public boolean hasProperty(String name) {
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public Set<Property> getProperties(String name) {
        HashSet<Property> ret = new HashSet<Property>();
        for (Property property : this.properties) {
            if (!property.getName().equals(name)) continue;
            ret.add(property);
        }
        return ret;
    }

    public String toString() {
        return "SourceInfo [id=" + this.id + ", endpoint=" + this.endpoint + ", timestamp=" + this.timestamp + ", duration=" + this.duration + ", fragmentId=" + this.fragmentId + ", hostName=" + this.hostName + ", hostAddress=" + this.hostAddress + ", multipleConsumers=" + this.multipleConsumers + ", properties=" + this.properties + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.endpoint == null ? 0 : this.endpoint.hashCode());
        result = 31 * result + (this.fragmentId == null ? 0 : this.fragmentId.hashCode());
        result = 31 * result + (this.hostAddress == null ? 0 : this.hostAddress.hashCode());
        result = 31 * result + (this.hostName == null ? 0 : this.hostName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.multipleConsumers ? 1231 : 1237);
        result = 31 * result + (this.properties == null ? 0 : this.properties.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SourceInfo other = (SourceInfo)obj;
        if (this.duration != other.duration) {
            return false;
        }
        if (this.endpoint == null ? other.endpoint != null : !this.endpoint.equals(other.endpoint)) {
            return false;
        }
        if (this.fragmentId == null ? other.fragmentId != null : !this.fragmentId.equals(other.fragmentId)) {
            return false;
        }
        if (this.hostAddress == null ? other.hostAddress != null : !this.hostAddress.equals(other.hostAddress)) {
            return false;
        }
        if (this.hostName == null ? other.hostName != null : !this.hostName.equals(other.hostName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.multipleConsumers != other.multipleConsumers) {
            return false;
        }
        if (this.properties == null ? other.properties != null : !this.properties.equals(other.properties)) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    @Override
    public void readExternal(ObjectInput ois) throws IOException, ClassNotFoundException {
        ois.readInt();
        this.id = SerializationUtil.deserializeString(ois);
        this.endpoint = (EndpointRef)ois.readObject();
        this.timestamp = ois.readLong();
        this.duration = ois.readLong();
        this.fragmentId = SerializationUtil.deserializeString(ois);
        this.hostName = SerializationUtil.deserializeString(ois);
        this.hostAddress = SerializationUtil.deserializeString(ois);
        this.multipleConsumers = ois.readBoolean();
        int size = ois.readInt();
        for (int i = 0; i < size; ++i) {
            this.properties.add((Property)ois.readObject());
        }
    }

    @Override
    public void writeExternal(ObjectOutput oos) throws IOException {
        oos.writeInt(1);
        SerializationUtil.serializeString(oos, this.id);
        oos.writeObject(this.endpoint);
        oos.writeLong(this.timestamp);
        oos.writeLong(this.duration);
        SerializationUtil.serializeString(oos, this.fragmentId);
        SerializationUtil.serializeString(oos, this.hostName);
        SerializationUtil.serializeString(oos, this.hostAddress);
        oos.writeBoolean(this.multipleConsumers);
        oos.writeInt(this.properties.size());
        for (Property property : this.properties) {
            oos.writeObject(property);
        }
    }
}

