/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.hawkular.apm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import shaded.org.hawkular.apm.api.internal.actions.ExpressionHandler;
import shaded.org.hawkular.apm.api.internal.actions.ExpressionHandlerFactory;
import shaded.org.hawkular.apm.api.internal.actions.ProcessorActionHandler;
import shaded.org.hawkular.apm.api.logging.Logger;
import shaded.org.hawkular.apm.api.model.Severity;
import shaded.org.hawkular.apm.api.model.config.Direction;
import shaded.org.hawkular.apm.api.model.config.btxn.ExpressionBasedAction;
import shaded.org.hawkular.apm.api.model.config.btxn.Processor;
import shaded.org.hawkular.apm.api.model.config.btxn.ProcessorAction;
import shaded.org.hawkular.apm.api.model.trace.Issue;
import shaded.org.hawkular.apm.api.model.trace.Node;
import shaded.org.hawkular.apm.api.model.trace.ProcessorIssue;
import shaded.org.hawkular.apm.api.model.trace.Trace;

public abstract class ExpressionBasedActionHandler
extends ProcessorActionHandler {
    public static final String EXPRESSION_HAS_NOT_BEEN_DEFINED = "Expression has not been defined";
    private static final Logger log = Logger.getLogger(ExpressionBasedActionHandler.class.getName());
    private ExpressionHandler expression = null;

    public ExpressionBasedActionHandler(ProcessorAction action) {
        super(action);
    }

    @Override
    public void init(Processor processor) {
        super.init(processor);
        if (((ExpressionBasedAction)this.getAction()).getExpression() != null) {
            try {
                this.expression = ExpressionHandlerFactory.getHandler(((ExpressionBasedAction)this.getAction()).getExpression());
                this.expression.init(processor, this.getAction(), false);
                if (!this.isUsesHeaders()) {
                    this.setUsesHeaders(this.expression.isUsesHeaders());
                }
                if (!this.isUsesContent()) {
                    this.setUsesContent(this.expression.isUsesContent());
                }
            }
            catch (Throwable t) {
                if (log.isLoggable(Logger.Level.FINE)) {
                    log.log(Logger.Level.FINE, "Failed to compile expression for action '" + this.getAction() + "'", t);
                }
                ProcessorIssue pi = new ProcessorIssue();
                pi.setProcessor(processor.getDescription());
                pi.setAction(this.getAction().getDescription());
                pi.setField("expression");
                pi.setSeverity(Severity.Error);
                pi.setDescription(t.getMessage());
                if (this.getIssues() == null) {
                    this.setIssues(new ArrayList<Issue>());
                }
                this.getIssues().add(pi);
            }
        } else {
            if (log.isLoggable(Logger.Level.FINE)) {
                log.fine("No action expression defined for processor action= " + this.getAction());
            }
            ProcessorIssue pi = new ProcessorIssue();
            pi.setProcessor(processor.getDescription());
            pi.setAction(this.getAction().getDescription());
            pi.setField("expression");
            pi.setSeverity(Severity.Error);
            pi.setDescription(EXPRESSION_HAS_NOT_BEEN_DEFINED);
            if (this.getIssues() == null) {
                this.setIssues(new ArrayList<Issue>());
            }
            this.getIssues().add(pi);
        }
    }

    protected String getValue(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        if (this.expression != null) {
            return this.expression.evaluate(trace, node, direction, headers, values);
        }
        return null;
    }
}

