/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.byteman.agent.adapter;

import org.jboss.byteman.agent.TransformContext;
import org.jboss.byteman.agent.adapter.RuleTriggerAdapter;
import org.jboss.byteman.agent.adapter.RuleTriggerMethodAdapter;
import org.jboss.byteman.objectweb.asm.ClassVisitor;
import org.jboss.byteman.objectweb.asm.Label;
import org.jboss.byteman.objectweb.asm.MethodVisitor;
import org.jboss.byteman.objectweb.asm.Type;
import org.jboss.byteman.rule.type.TypeHelper;

public class ExceptionExitTriggerAdapter
extends RuleTriggerAdapter {
    public ExceptionExitTriggerAdapter(ClassVisitor cv, TransformContext transformContext) {
        super(cv, transformContext);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (this.injectIntoMethod(name, desc)) {
            if (name.equals("<init>")) {
                return new ExceptionExitTriggerConstructorAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
            }
            return new ExceptionExitTriggerMethodAdapter(mv, this.getTransformContext(), access, name, desc, signature, exceptions);
        }
        return mv;
    }

    private class ExceptionExitTriggerConstructorAdapter
    extends ExceptionExitTriggerMethodAdapter {
        ExceptionExitTriggerConstructorAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, ExceptionExitTriggerAdapter.this.getTransformContext(), access, name, descriptor, signature, exceptions);
        }

        @Override
        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }

    private class ExceptionExitTriggerMethodAdapter
    extends RuleTriggerMethodAdapter {
        private Label newStart;

        ExceptionExitTriggerMethodAdapter(MethodVisitor mv, TransformContext transformContext, int access, String name, String descriptor, String signature, String[] exceptions) {
            super(mv, transformContext, access, name, descriptor, signature, exceptions);
        }

        @Override
        public void visitCode() {
            super.visitCode();
            this.newStart = this.newLabel();
            this.visitLabel(this.newStart);
        }

        @Override
        public void visitMaxs(int maxStack, int maxLocals) {
            Label newEnd = this.newLabel();
            Label throwableCatch = this.newLabel();
            this.visitTryCatchBlock(this.newStart, newEnd, throwableCatch, Type.getType(TypeHelper.externalizeType("java.lang.Throwable")).getInternalName());
            this.visitLabel(newEnd);
            this.visitLabel(throwableCatch);
            this.injectTriggerPoint();
            this.throwException();
            super.visitMaxs(maxStack, maxLocals);
        }
    }
}

