/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.utils.zipkin;

import java.util.List;
import org.hawkular.apm.server.api.model.zipkin.Span;
import org.hawkular.apm.server.api.utils.zipkin.SpanHttpDeriverUtil;

public class SpanDeriverUtil {
    private SpanDeriverUtil() {
    }

    public static String deriveOperation(Span span) {
        if (SpanHttpDeriverUtil.isHttp(span)) {
            return SpanHttpDeriverUtil.getHttpMethod(span);
        }
        return span.getName();
    }

    public static String deriveFault(Span span) {
        List<SpanHttpDeriverUtil.HttpCode> errorCodes = SpanHttpDeriverUtil.getClientOrServerErrors(SpanHttpDeriverUtil.getHttpStatusCodes(span.getBinaryAnnotations()));
        if (errorCodes.size() > 0) {
            return errorCodes.iterator().next().getDescription();
        }
        return null;
    }
}

