/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.server.api.task;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.hawkular.apm.server.api.task.Handler;
import org.hawkular.apm.server.api.task.Processor;
import org.hawkular.apm.server.api.task.RetryAttemptException;

public class ProcessingUnit<T, R>
implements Handler<T> {
    private static final Logger perfLog = Logger.getLogger("org.hawkular.apm.performance");
    private Processor<T, R> processor;
    private int retryCount;
    private String retrySubscriber;
    private Handler<R> resultHandler;
    private Handler<T> retryHandler;

    public Processor<T, R> getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor<T, R> processor) {
        this.processor = processor;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    public void setRetryCount(int retryCount) {
        this.retryCount = retryCount;
    }

    public String getRetrySubscriber() {
        return this.retrySubscriber;
    }

    public void setRetrySubscriber(String retrySubscriber) {
        this.retrySubscriber = retrySubscriber;
    }

    public Handler<R> getResultHandler() {
        return this.resultHandler;
    }

    public void setResultHandler(Handler<R> resultHandler) {
        this.resultHandler = resultHandler;
    }

    public Handler<T> getRetryHandler() {
        return this.retryHandler;
    }

    public void setRetryHandler(Handler<T> retryHandler) {
        this.retryHandler = retryHandler;
    }

    @Override
    public void handle(String tenantId, List<T> items) throws Exception {
        List<R> results = null;
        List<T> retries = null;
        RetryAttemptException lastException = null;
        try {
            this.processor.initialise(tenantId, items);
            long startTime = 0L;
            if (perfLog.isLoggable(Level.FINEST)) {
                startTime = System.currentTimeMillis();
            }
            if (this.processor.getType() == Processor.ProcessorType.ManyToMany) {
                results = this.processor.processManyToMany(tenantId, items);
            } else {
                for (int i = 0; i < items.size(); ++i) {
                    try {
                        List<R> result;
                        if (this.processor.getType() == Processor.ProcessorType.OneToMany) {
                            result = this.processor.processOneToMany(tenantId, items.get(i));
                            if (this.resultHandler == null || result == null || result.isEmpty()) continue;
                            if (results == null) {
                                results = new ArrayList<R>();
                            }
                            results.addAll(result);
                            continue;
                        }
                        result = this.processor.processOneToOne(tenantId, items.get(i));
                        if (this.resultHandler == null || result == null) continue;
                        if (results == null) {
                            results = new ArrayList<R>();
                        }
                        results.add(result);
                        continue;
                    }
                    catch (RetryAttemptException e) {
                        if (this.retryHandler == null) continue;
                        if (retries == null) {
                            retries = new ArrayList<T>();
                        }
                        retries.add(items.get(i));
                        lastException = e;
                    }
                }
            }
            if (perfLog.isLoggable(Level.FINEST)) {
                perfLog.finest("Performance: invoked processor [" + this.processor.getClass().getSimpleName() + "] duration=" + (System.currentTimeMillis() - startTime) + "ms");
            }
        }
        catch (RetryAttemptException e) {
            retries = items;
            lastException = e;
        }
        this.processor.cleanup(tenantId, items);
        if (results != null && !results.isEmpty()) {
            this.resultHandler.handle(tenantId, results);
        }
        if (retries != null && !retries.isEmpty()) {
            if (this.getRetryCount() > 0) {
                this.retryHandler.handle(tenantId, retries);
            } else {
                throw lastException;
            }
        }
    }
}

