/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.apm.api.internal.actions;

import java.util.ArrayList;
import java.util.Map;
import org.hawkular.apm.api.internal.actions.ExpressionHandler;
import org.hawkular.apm.api.model.Severity;
import org.hawkular.apm.api.model.config.Direction;
import org.hawkular.apm.api.model.config.btxn.Expression;
import org.hawkular.apm.api.model.config.btxn.LiteralExpression;
import org.hawkular.apm.api.model.config.btxn.Processor;
import org.hawkular.apm.api.model.config.btxn.ProcessorAction;
import org.hawkular.apm.api.model.trace.Issue;
import org.hawkular.apm.api.model.trace.Node;
import org.hawkular.apm.api.model.trace.ProcessorIssue;
import org.hawkular.apm.api.model.trace.Trace;

public class LiteralExpressionHandler
extends ExpressionHandler {
    private boolean predicateResult = false;

    public LiteralExpressionHandler(Expression expression) {
        super(expression);
    }

    @Override
    public void init(Processor processor, ProcessorAction action, boolean predicate) {
        LiteralExpression expr = (LiteralExpression)this.getExpression();
        if (predicate) {
            if (!expr.getValue().equalsIgnoreCase("true") && !expr.getValue().equalsIgnoreCase("false")) {
                ProcessorIssue pi = new ProcessorIssue();
                pi.setProcessor(processor.getDescription());
                pi.setAction(action.getDescription());
                pi.setSeverity(Severity.Error);
                pi.setDescription("Literal expression must have a boolean (true/false) value when used as a predicate");
                if (this.getIssues() == null) {
                    this.setIssues(new ArrayList<Issue>());
                }
                this.getIssues().add(pi);
            } else {
                this.predicateResult = new Boolean(((LiteralExpression)this.getExpression()).getValue());
            }
        }
    }

    @Override
    public boolean test(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        return this.predicateResult;
    }

    @Override
    public String evaluate(Trace trace, Node node, Direction direction, Map<String, ?> headers, Object[] values) {
        return ((LiteralExpression)this.getExpression()).getValue();
    }
}

