/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest.accounts;

import java.io.IOException;
import javax.enterprise.inject.Instance;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.ext.Provider;
import org.hawkular.accounts.api.model.Persona;
import org.hawkular.alerts.rest.ResponseUtil;
import org.jboss.logging.Logger;

@Provider
public class PersonaFilter
implements ContainerRequestFilter {
    private final Logger log = Logger.getLogger(PersonaFilter.class);
    @Inject
    Instance<Persona> personaInstance;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (requestContext.getHeaderString("Hawkular-Tenant") != null) {
            requestContext.abortWith(ResponseUtil.badRequest((String)"Hawkular-Tenant should not be provided on Hawkular deployment."));
        }
        if (!this.checkPersona()) {
            requestContext.abortWith(ResponseUtil.internalError((String)"No persona found"));
        }
        requestContext.getHeaders().putSingle((Object)"Hawkular-Tenant", (Object)((Persona)this.personaInstance.get()).getIdAsUUID().toString());
    }

    private boolean checkPersona() {
        if (this.personaInstance == null || this.personaInstance.get() == null) {
            this.log.warn((Object)"Persona is null. Possible issue with accounts integration ? ");
            return false;
        }
        if (((Persona)this.personaInstance.get()).getIdAsUUID() == null) {
            this.log.warn((Object)"Persona is empty. Possible issue with accounts integration ? ");
            return false;
        }
        return true;
    }
}

