/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.rest;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiParam;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.ejb.EJB;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.alerts.api.exception.NotFoundException;
import org.hawkular.alerts.api.json.GroupMemberInfo;
import org.hawkular.alerts.api.json.JacksonDeserializer;
import org.hawkular.alerts.api.json.UnorphanMemberInfo;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.paging.Page;
import org.hawkular.alerts.api.model.paging.Pager;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;
import org.hawkular.alerts.api.services.DefinitionsService;
import org.hawkular.alerts.api.services.TriggersCriteria;
import org.hawkular.alerts.rest.RequestUtil;
import org.hawkular.alerts.rest.ResponseUtil;
import org.hawkular.alerts.rest.TriggersHandler;
import org.jboss.logging.Logger;

@Path(value="/triggers")
@Api(value="/triggers", description="Trigger Handling")
public class TriggersHandler {
    private static final Logger log = Logger.getLogger(TriggersHandler.class);
    @HeaderParam(value="Hawkular-Tenant")
    String tenantId;
    @EJB
    DefinitionsService definitions;
    ObjectMapper objectMapper;

    public TriggersHandler() {
        log.debug((Object)"Creating instance.");
        this.objectMapper = new ObjectMapper();
    }

    @GET
    @Path(value="/")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get triggers with optional filtering")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response findTriggers(@ApiParam(required=false, value="filter out triggers for unspecified triggerIds, comma separated list of trigger IDs") @QueryParam(value="triggerIds") String triggerIds, @ApiParam(required=false, value="filter out triggers for unspecified tags, comma separated list of tags, each tag of format 'name|value'. Specify '*' for value to match all values.") @QueryParam(value="tags") String tags, @ApiParam(required=false, value="return only thin triggers. Currently Ignored") @QueryParam(value="thin") Boolean thin, @Context UriInfo uri) {
        Pager pager = RequestUtil.extractPaging((UriInfo)uri);
        try {
            TriggersCriteria criteria = this.buildCriteria(triggerIds, tags, thin);
            Page triggerPage = this.definitions.getTriggers(this.tenantId, criteria, pager);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Triggers: " + triggerPage));
            }
            if (this.isEmpty((Collection)triggerPage)) {
                return ResponseUtil.ok((Object)triggerPage);
            }
            return ResponseUtil.paginatedOk((Page)triggerPage, (UriInfo)uri);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private TriggersCriteria buildCriteria(String triggerIds, String tags, Boolean thin) {
        TriggersCriteria criteria = new TriggersCriteria();
        if (!this.isEmpty(triggerIds)) {
            criteria.setTriggerIds(Arrays.asList(triggerIds.split(",")));
        }
        if (!this.isEmpty(tags)) {
            String[] tagTokens = tags.split(",");
            HashMap<String, String> tagsMap = new HashMap<String, String>(tagTokens.length);
            for (String tagToken : tagTokens) {
                Object[] fields = tagToken.split("\\|");
                if (fields.length != 2) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Invalid Tag Criteria " + Arrays.toString(fields)));
                    }
                    throw new IllegalArgumentException("Invalid Tag Criteria " + Arrays.toString(fields));
                }
                tagsMap.put(fields[0], fields[1]);
            }
            criteria.setTags(tagsMap);
        }
        if (null != thin) {
            criteria.setThin(thin.booleanValue());
        }
        return criteria;
    }

    @GET
    @Path(value="/groups/{groupId}/members")
    @Produces(value={"application/json"})
    @ApiOperation(value="Find all Group Member Trigger Definitions", notes="Pagination is not yet implemented")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response findGroupMembers(@ApiParam(value="Group TriggerId", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="include Orphan members? No if omitted.", required=false) @QueryParam(value="includeOrphans") boolean includeOrphans) {
        try {
            Collection members = this.definitions.getMemberTriggers(this.tenantId, groupId, includeOrphans);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member Triggers: " + members));
            }
            return ResponseUtil.ok((Object)members);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new trigger", response=Trigger.class, notes="Returns created Trigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createTrigger(@ApiParam(value="Trigger definition to be created", name="trigger", required=true) Trigger trigger) {
        try {
            if (null != trigger) {
                if (this.isEmpty(trigger.getId())) {
                    trigger.setId(Trigger.generateId());
                } else if (this.definitions.getTrigger(this.tenantId, trigger.getId()) != null) {
                    return ResponseUtil.badRequest((String)("Trigger with ID [" + trigger.getId() + "] exists."));
                }
                this.definitions.addTrigger(this.tenantId, trigger);
                log.debug((Object)("Trigger: " + trigger.toString()));
                return ResponseUtil.ok((Object)trigger);
            }
            return ResponseUtil.badRequest((String)"Trigger is null");
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/groups")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new group trigger", response=Trigger.class, notes="Returns created GroupTrigger")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Trigger Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createGroupTrigger(@ApiParam(value="Trigger definition to be created", name="groupTrigger", required=true) Trigger groupTrigger) {
        try {
            if (null != groupTrigger) {
                if (this.isEmpty(groupTrigger.getId())) {
                    groupTrigger.setId(Trigger.generateId());
                } else if (this.definitions.getTrigger(this.tenantId, groupTrigger.getId()) != null) {
                    return ResponseUtil.badRequest((String)("Trigger with ID [" + groupTrigger.getId() + "] exists."));
                }
                this.definitions.addGroupTrigger(this.tenantId, groupTrigger);
                log.debug((Object)("Group Trigger: " + groupTrigger.toString()));
                return ResponseUtil.ok((Object)groupTrigger);
            }
            return ResponseUtil.badRequest((String)"Trigger is null");
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/groups/members")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new member trigger for a parent trigger.", response=Trigger.class, notes="Returns Member Trigger created if operation finished correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Member Trigger Created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Group trigger not found."), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createGroupMember(@ApiParam(value="Group member trigger to be created", name="groupMember", required=true) GroupMemberInfo groupMember) {
        try {
            if (null == groupMember) {
                return ResponseUtil.badRequest((String)"MemberTrigger is null");
            }
            String groupId = groupMember.getGroupId();
            String memberName = groupMember.getMemberName();
            if (this.isEmpty(groupId)) {
                return ResponseUtil.badRequest((String)"MemberTrigger groupId is null");
            }
            if (this.isEmpty(memberName)) {
                return ResponseUtil.badRequest((String)"MemberTrigger memberName is null");
            }
            Trigger child = this.definitions.addMemberTrigger(this.tenantId, groupId, groupMember.getMemberId(), memberName, groupMember.getMemberContext(), groupMember.getDataIdMap());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Child Trigger: " + child.toString()));
            }
            return ResponseUtil.ok((Object)child);
        }
        catch (NotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing trigger definition", response=Trigger.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger found"), @ApiResponse(code=404, message="Trigger not found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTrigger(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Trigger found = this.definitions.getTrigger(this.tenantId, triggerId);
            if (found != null) {
                log.debug((Object)("Trigger: " + found));
                return ResponseUtil.ok((Object)found);
            }
            return ResponseUtil.notFound((String)("triggerId: " + triggerId + " not found"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{triggerId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing trigger definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger doesn't exist/Invalid Parameters")})
    public Response updateTrigger(@ApiParam(value="Trigger definition id to be updated", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Updated trigger definition", name="trigger", required=true) Trigger trigger) {
        try {
            if (trigger != null && !this.isEmpty(triggerId)) {
                trigger.setId(triggerId);
            }
            this.definitions.updateTrigger(this.tenantId, trigger);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trigger: " + trigger));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Trigger " + triggerId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/groups/{groupId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing group trigger definition and its member definitions")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Trigger updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger doesn't exist/Invalid Parameters")})
    public Response updateGroupTrigger(@ApiParam(value="Group Trigger id to be updated", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Updated group trigger definition", name="trigger", required=true) Trigger groupTrigger) {
        try {
            if (groupTrigger != null && !this.isEmpty(groupId)) {
                groupTrigger.setId(groupId);
            }
            this.definitions.updateGroupTrigger(this.tenantId, groupTrigger);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Trigger: " + groupTrigger));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Trigger " + groupId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/groups/members/{memberId}/orphan")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Make a non-orphan member trigger into an orphan.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger doesn't exist/Invalid Parameters")})
    public Response orphanMemberTrigger(@ApiParam(value="Member Trigger id to be made an orphan.", required=true) @PathParam(value="memberId") String memberId) {
        try {
            Trigger child = this.definitions.orphanMemberTrigger(this.tenantId, memberId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Orphan Member Trigger: " + child));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Member Trigger " + memberId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/groups/members/{memberId}/unorphan")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Make a non-orphan member trigger into an orphan.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger updated"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger doesn't exist/Invalid Parameters")})
    public Response unorphanMemberTrigger(@ApiParam(value="Member Trigger id to be made an orphan.", required=true) @PathParam(value="memberId") String memberId, @ApiParam(required=true, name="memberTrigger", value="Only context and dataIdMap are used when changing back to a non-orphan.") UnorphanMemberInfo unorphanMemberInfo) {
        try {
            if (null == unorphanMemberInfo) {
                return ResponseUtil.badRequest((String)"MemberTrigger is null");
            }
            Trigger child = this.definitions.unorphanMemberTrigger(this.tenantId, memberId, unorphanMemberInfo.getMemberContext(), unorphanMemberInfo.getDataIdMap());
            if (log.isDebugEnabled()) {
                log.debug((Object)("Member Trigger: " + child));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Member Trigger " + memberId + " doesn't exist for update"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{triggerId}")
    @ApiOperation(value="Delete an existing trigger definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Trigger deleted"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Trigger not found")})
    public Response deleteTrigger(@ApiParam(value="Trigger definition id to be deleted", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            this.definitions.removeTrigger(this.tenantId, triggerId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("TriggerId: " + triggerId));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)("Trigger " + triggerId + " doesn't exist for delete"));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/groups/{groupId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a group trigger.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Trigger Removed"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=404, message="Group Trigger not found"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response deleteGroupTrigger(@ApiParam(required=true, value="Group Trigger id") @PathParam(value="groupId") String groupId, @ApiParam(required=true, value="Convert the non-orphan member triggers to standard triggers.") @QueryParam(value="keepNonOrphans") boolean keepNonOrphans, @ApiParam(required=true, value="Convert the orphan member triggers to standard triggers.") @QueryParam(value="keepOrphans") boolean keepOrphans) {
        try {
            this.definitions.removeGroupTrigger(this.tenantId, groupId, keepNonOrphans, keepOrphans);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Remove Group Trigger: " + this.tenantId + "/" + groupId));
            }
            return ResponseUtil.ok();
        }
        catch (NotFoundException e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all Dampenings for a Trigger (1 Dampening per mode).")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerDampenings(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Collection dampenings = this.definitions.getTriggerDampenings(this.tenantId, triggerId, null);
            log.debug((Object)("Dampenings: " + dampenings));
            return ResponseUtil.ok((Object)dampenings);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/mode/{triggerMode}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get a dampening using triggerId and triggerMode")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerModeDampenings(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Trigger mode", required=true) @PathParam(value="triggerMode") Mode triggerMode) {
        try {
            Collection dampenings = this.definitions.getTriggerDampenings(this.tenantId, triggerId, triggerMode);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Dampenings: " + dampenings));
            }
            return ResponseUtil.ok((Object)dampenings);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get an existing dampening")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Found"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response getDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            Dampening found = this.definitions.getDampening(this.tenantId, dampeningId);
            log.debug((Object)("Dampening: " + found));
            if (found == null) {
                return ResponseUtil.notFound((String)("No dampening found for triggerId: " + triggerId + " and dampeningId:" + dampeningId));
            }
            return ResponseUtil.ok((Object)found);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/{triggerId}/dampenings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new dampening", notes="Returns Dampening created if operation finishes correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createDampening(@ApiParam(value="Trigger definition id attached to dampening", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening definition to be created", required=true) Dampening dampening) {
        try {
            boolean exists;
            dampening.setTenantId(this.tenantId);
            dampening.setTriggerId(triggerId);
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampening.getDampeningId()) != null;
            if (!exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.addDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.badRequest((String)("Existing dampening for dampeningId: " + dampening.getDampeningId()));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/groups/{groupId}/dampenings")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new group dampening", notes="Returns Dampening created if operation finishes correctly")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening created"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response createGroupDampening(@ApiParam(value="Group Trigger definition id attached to dampening", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Dampening definition to be created", required=true) Dampening dampening) {
        try {
            boolean exists;
            dampening.setTriggerId(groupId);
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampening.getDampeningId()) != null;
            if (!exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.addGroupDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.badRequest((String)("Existing dampening for dampeningId: " + dampening.getDampeningId()));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private Dampening getCleanDampening(Dampening dampening) throws Exception {
        switch (1.$SwitchMap$org$hawkular$alerts$api$model$dampening$Dampening$Type[dampening.getType().ordinal()]) {
            case 1: {
                return Dampening.forStrict((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting());
            }
            case 2: {
                return Dampening.forStrictTime((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 3: {
                return Dampening.forStrictTimeout((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (long)dampening.getEvalTimeSetting());
            }
            case 4: {
                return Dampening.forRelaxedCount((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (int)dampening.getEvalTotalSetting());
            }
            case 5: {
                return Dampening.forRelaxedTime((String)dampening.getTenantId(), (String)dampening.getTriggerId(), (Mode)dampening.getTriggerMode(), (int)dampening.getEvalTrueSetting(), (long)dampening.getEvalTimeSetting());
            }
        }
        throw new Exception("Unhandled Dampening Type: " + dampening.toString());
    }

    @PUT
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing dampening definition. Note that the trigger mode can not be changed.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Updated"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId, @ApiParam(value="Updated dampening definition", required=true) Dampening dampening) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.updateDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.notFound((String)("No dampening found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/groups/{groupId}/dampenings/{dampeningId}")
    @Consumes(value={"application/json"})
    @ApiOperation(value="Update an existing group dampening definition. Note that trigger mode can not be changed.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening Updated"), @ApiResponse(code=404, message="No Dampening Found"), @ApiResponse(code=500, message="Internal server error")})
    public Response updateGroupDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Dampening id", required=true) @PathParam(value="dampeningId") String dampeningId, @ApiParam(value="Updated dampening definition", required=true) Dampening dampening) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                Dampening d = this.getCleanDampening(dampening);
                this.definitions.updateGroupDampening(this.tenantId, d);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Group Dampening: " + d));
                }
                return ResponseUtil.ok((Object)d);
            }
            return ResponseUtil.notFound((String)("No dampening found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{triggerId}/dampenings/{dampeningId}")
    @ApiOperation(value="Delete an existing dampening definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening deleted"), @ApiResponse(code=404, message="No Dampening found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteDampening(@ApiParam(value="Trigger definition id to be deleted", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Dampening id for dampening definition to be deleted", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                this.definitions.removeDampening(this.tenantId, dampeningId);
                log.debug((Object)("DampeningId: " + dampeningId));
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Dampening not found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/groups/{groupId}/dampenings/{dampeningId}")
    @ApiOperation(value="Delete an existing group dampening definition")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Dampening deleted"), @ApiResponse(code=404, message="No Dampening found"), @ApiResponse(code=500, message="Internal server error")})
    public Response deleteGroupDampening(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="Dampening id for dampening definition to be deleted", required=true) @PathParam(value="dampeningId") String dampeningId) {
        try {
            boolean exists;
            boolean bl = exists = this.definitions.getDampening(this.tenantId, dampeningId) != null;
            if (exists) {
                this.definitions.removeGroupDampening(this.tenantId, dampeningId);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Group DampeningId: " + dampeningId));
                }
                return ResponseUtil.ok();
            }
            return ResponseUtil.notFound((String)("Dampening not found for dampeningId: " + dampeningId));
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get all conditions for a specific trigger.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal server error")})
    public Response getTriggerConditions(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId) {
        try {
            Collection conditions = this.definitions.getTriggerConditions(this.tenantId, triggerId, null);
            log.debug((Object)("Conditions: " + conditions));
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @GET
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="@Deprecated : Use GET /alerts/triggers/{triggerId}/conditions")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition found"), @ApiResponse(code=404, message="No Condition found"), @ApiResponse(code=500, message="Internal server error")})
    @Deprecated
    public Response getTriggerCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        try {
            Trigger trigger = this.definitions.getTrigger(this.tenantId, triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            Condition found = this.definitions.getCondition(this.tenantId, conditionId);
            if (found == null) {
                return ResponseUtil.notFound((String)("No condition found for conditionId: " + conditionId));
            }
            if (!found.getTriggerId().equals(triggerId)) {
                return ResponseUtil.notFound((String)("ConditionId: " + conditionId + " does not belong to triggerId: " + triggerId));
            }
            return ResponseUtil.ok((Object)found);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{triggerId}/conditions/{triggerMode}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Set the conditions for the trigger. This replaces any existing conditions. Returns the new conditions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition Set created"), @ApiResponse(code=404, message="No trigger found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response setConditions(@ApiParam(value="The relevant Trigger.", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="FIRING or AUTORESOLVE (not case sensitive).", required=true) @PathParam(value="triggerMode") String triggerMode, @ApiParam(value="Json representation of a condition list. For examples of Condition types, See https://github.com/hawkular/hawkular-alerts/blob/master/hawkular-alerts-rest-tests/src/test/groovy/org/hawkular/alerts/rest/ConditionsITest.groovy") String jsonConditions) {
        try {
            Mode mode = Mode.valueOf((String)triggerMode.toUpperCase());
            Collection<Condition> conditions = new ArrayList();
            if (!this.isEmpty(jsonConditions)) {
                ObjectMapper om = new ObjectMapper();
                JsonNode rootNode = om.readTree(jsonConditions);
                for (JsonNode conditionNode : rootNode) {
                    Condition condition = JacksonDeserializer.deserializeCondition((JsonNode)conditionNode);
                    if (condition == null) {
                        return ResponseUtil.badRequest((String)("Bad json conditions: " + jsonConditions));
                    }
                    condition.setTriggerId(triggerId);
                    condition.setTriggerMode(mode);
                    conditions.add(condition);
                }
            }
            conditions = this.definitions.setConditions(this.tenantId, triggerId, mode, conditions);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok(conditions);
        }
        catch (IllegalArgumentException e) {
            return ResponseUtil.badRequest((String)("Bad argument: " + e.getMessage()));
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/groups/{groupId}/conditions/{triggerMode}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Set the conditions for the group trigger. This replaces any existing conditions on the group and member conditions.  Returns the new group conditions.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Group Condition Set created"), @ApiResponse(code=404, message="No trigger found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    public Response setGroupConditions(@ApiParam(value="The relevant Group Trigger.", required=true) @PathParam(value="groupId") String groupId, @ApiParam(value="FIRING or AUTORESOLVE (not case sensitive).", required=true) @PathParam(value="triggerMode") String triggerMode, @ApiParam(value="Json representation of GroupConditionsInfo. For examples of Condition types, See https://github.com/hawkular/hawkular-alerts/blob/master/hawkular-alerts-rest-tests/src/test/groovy/org/hawkular/alerts/rest/ConditionsITest.groovy") String jsonGroupConditionsInfo) {
        try {
            if (this.isEmpty(jsonGroupConditionsInfo)) {
                return ResponseUtil.badRequest((String)"GroupConditionsInfo can not be null");
            }
            Mode mode = Mode.valueOf((String)triggerMode.toUpperCase());
            Collection<Object> conditions = new ArrayList<Condition>();
            ObjectMapper om = new ObjectMapper();
            JsonNode rootNode = om.readTree(jsonGroupConditionsInfo);
            JsonNode conditionsNode = rootNode.get("conditions");
            for (JsonNode conditionNode : conditionsNode) {
                Condition condition = JacksonDeserializer.deserializeCondition((JsonNode)conditionNode);
                if (condition == null) {
                    return ResponseUtil.badRequest((String)("Bad json conditions: " + conditionsNode.toString()));
                }
                condition.setTriggerId(groupId);
                condition.setTriggerMode(mode);
                conditions.add(condition);
            }
            JsonNode dataIdMemberMapNode = rootNode.get("dataIdMemberMap");
            Map dataIdMemberMap = null;
            if (null != dataIdMemberMapNode) {
                dataIdMemberMap = (Map)om.treeToValue((TreeNode)dataIdMemberMapNode, Map.class);
            }
            conditions = this.definitions.setGroupConditions(this.tenantId, groupId, mode, conditions, dataIdMemberMap);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok(conditions);
        }
        catch (IllegalArgumentException e) {
            return ResponseUtil.badRequest((String)("Bad trigger mode: " + triggerMode));
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @POST
    @Path(value="/{triggerId}/conditions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated : Use PUT /alerts/triggers/{triggerId}/conditions to set the entire condition set in one service.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition created"), @ApiResponse(code=404, message="No trigger found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    @Deprecated
    public Response createCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @ApiParam(value="Json representation of a condition. For examples of Condition types, See https://github.com/hawkular/hawkular-alerts/blob/master/hawkular-alerts-rest-tests/src/test/groovy/org/hawkular/alerts/rest/ConditionsITest.groovy") String jsonCondition) {
        try {
            if (this.isEmpty(jsonCondition) || !jsonCondition.contains("type")) {
                return ResponseUtil.badRequest((String)"json condition empty or without type");
            }
            ObjectMapper om = new ObjectMapper();
            JsonNode rootNode = om.readTree(jsonCondition);
            Condition condition = JacksonDeserializer.deserializeCondition((JsonNode)rootNode);
            if (condition == null) {
                return ResponseUtil.badRequest((String)"Bad json condition");
            }
            condition.setTriggerId(triggerId);
            Collection conditions = this.definitions.addCondition(this.tenantId, condition.getTriggerId(), condition.getTriggerMode(), condition);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (NotFoundException e) {
            return ResponseUtil.notFound((String)e.getMessage());
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @PUT
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated : Use PUT /alerts/triggers/{triggerId}/conditions to set the entire condition set in one service.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition updated"), @ApiResponse(code=404, message="No Condition found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    @Deprecated
    public Response updateCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId, @ApiParam(value="Json representation of a condition") String jsonCondition) {
        try {
            Trigger trigger = this.definitions.getTrigger(this.tenantId, triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            if (this.isEmpty(jsonCondition) || !jsonCondition.contains("type")) {
                return ResponseUtil.badRequest((String)"json condition empty or without type");
            }
            ObjectMapper om = new ObjectMapper();
            JsonNode rootNode = om.readTree(jsonCondition);
            Condition condition = JacksonDeserializer.deserializeCondition((JsonNode)rootNode);
            if (condition == null) {
                return ResponseUtil.badRequest((String)"Bad json condition");
            }
            condition.setTriggerId(triggerId);
            boolean exists = false;
            if (conditionId.equals(condition.getConditionId())) {
                boolean bl = exists = this.definitions.getCondition(this.tenantId, condition.getConditionId()) != null;
            }
            if (!exists) {
                return ResponseUtil.notFound((String)("Condition not found for conditionId: " + conditionId));
            }
            Collection conditions = this.definitions.updateCondition(this.tenantId, condition);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    @DELETE
    @Path(value="/{triggerId}/conditions/{conditionId}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deprecated : Use PUT /alerts/triggers/{triggerId}/conditions to set the entire condition set in one service.")
    @ApiResponses(value={@ApiResponse(code=200, message="Success, Condition deleted"), @ApiResponse(code=404, message="No Condition found"), @ApiResponse(code=500, message="Internal server error"), @ApiResponse(code=400, message="Bad Request/Invalid Parameters")})
    @Deprecated
    public Response deleteCondition(@ApiParam(value="Trigger definition id to be retrieved", required=true) @PathParam(value="triggerId") String triggerId, @PathParam(value="conditionId") String conditionId) {
        try {
            Trigger trigger = this.definitions.getTrigger(this.tenantId, triggerId);
            if (trigger == null) {
                return ResponseUtil.notFound((String)("No trigger found for triggerId: " + triggerId));
            }
            Condition condition = this.definitions.getCondition(this.tenantId, conditionId);
            if (condition == null) {
                return ResponseUtil.notFound((String)("No condition found for conditionId: " + conditionId));
            }
            if (!condition.getTriggerId().equals(triggerId)) {
                return ResponseUtil.badRequest((String)("ConditionId: " + conditionId + " does not belong to triggerId: " + triggerId));
            }
            Collection conditions = this.definitions.removeCondition(this.tenantId, conditionId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Conditions: " + conditions));
            }
            return ResponseUtil.ok((Object)conditions);
        }
        catch (Exception e) {
            log.debug((Object)e.getMessage(), (Throwable)e);
            return ResponseUtil.internalError((String)e.getMessage());
        }
    }

    private boolean isEmpty(String s) {
        return null == s || s.trim().isEmpty();
    }

    private boolean isEmpty(Collection collection) {
        return collection == null || collection.isEmpty();
    }
}

