/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.webhook;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.logging.Logger;

public class WebHooks {
    private static final Logger log = Logger.getLogger(WebHooks.class);
    private static WebHooks instance = new WebHooks();
    private boolean supportsFile = false;
    private String webhooksFile;
    private ObjectMapper mapper;
    private Map<String, List<Map<String, String>>> webhooks = new HashMap();

    private WebHooks() {
        this.mapper = new ObjectMapper();
    }

    public static synchronized void setFile(String file) {
        WebHooks.instance.supportsFile = true;
        WebHooks.instance.webhooksFile = file;
    }

    public static synchronized void releaseFile() {
        WebHooks.instance.supportsFile = false;
        WebHooks.instance.webhooksFile = null;
    }

    public static String getFile() {
        return WebHooks.instance.webhooksFile;
    }

    public static boolean isSupportsFile() {
        return WebHooks.instance.supportsFile;
    }

    public static synchronized void loadFile() throws IOException {
        File f = new File(WebHooks.instance.webhooksFile);
        Path path = f.toPath();
        StringBuilder fullFile = new StringBuilder();
        Files.lines(path).forEach(s -> fullFile.append((String)s));
        log.debug((Object)("Reading webhooks... " + fullFile.toString()));
        WebHooks.instance.webhooks = (Map)WebHooks.instance.mapper.readValue(fullFile.toString(), Map.class);
    }

    public static synchronized void addWebHook(String tenantId, String filter, String url) throws IOException {
        if (!WebHooks.instance.webhooks.containsKey(tenantId)) {
            WebHooks.instance.webhooks.put(tenantId, new ArrayList());
        }
        List tenantWebHooks = (List)WebHooks.instance.webhooks.get(tenantId);
        Map<String, String> webhook = null;
        for (int i = 0; i < tenantWebHooks.size(); ++i) {
            Map item = (Map)tenantWebHooks.get(i);
            if (!item.containsKey("url") || !((String)item.get("url")).equals(url)) continue;
            webhook = item;
            break;
        }
        if (webhook == null) {
            webhook = new HashMap<String, String>();
            tenantWebHooks.add(webhook);
        }
        webhook.put("url", url);
        webhook.put("filter", filter);
        if (WebHooks.instance.supportsFile) {
            File f = new File(WebHooks.instance.webhooksFile);
            WebHooks.instance.mapper.writeValue(f, (Object)WebHooks.instance.webhooks);
        }
    }

    public static synchronized void removeWebHook(String tenantId, String url) throws IOException {
        if (!WebHooks.instance.webhooks.containsKey(tenantId)) {
            return;
        }
        List tenantWebHooks = (List)WebHooks.instance.webhooks.get(tenantId);
        for (int i = 0; i < tenantWebHooks.size(); ++i) {
            Map item = (Map)tenantWebHooks.get(i);
            if (!item.containsKey("url") || !((String)item.get("url")).equals(url)) continue;
            tenantWebHooks.remove(i);
            break;
        }
        if (WebHooks.instance.supportsFile) {
            File f = new File(WebHooks.instance.webhooksFile);
            WebHooks.instance.mapper.writeValue(f, (Object)WebHooks.instance.webhooks);
        }
    }

    public static List<Map<String, String>> getWebHooks(String tenantId) {
        return (List)WebHooks.instance.webhooks.get(tenantId);
    }

    public static synchronized void removeWebHooks(String tenantId) throws IOException {
        WebHooks.instance.webhooks.remove(tenantId);
        if (WebHooks.instance.supportsFile) {
            File f = new File(WebHooks.instance.webhooksFile);
            WebHooks.instance.mapper.writeValue(f, (Object)WebHooks.instance.webhooks);
        }
    }

    public static Map<String, List<Map<String, String>>> getAllWebHooks() {
        return Collections.unmodifiableMap(WebHooks.instance.webhooks);
    }

    public static void removeWebHooks() throws IOException {
        WebHooks.instance.webhooks.clear();
        if (WebHooks.instance.supportsFile) {
            File f = new File(WebHooks.instance.webhooksFile);
            WebHooks.instance.mapper.writeValue(f, (Object)WebHooks.instance.webhooks);
        }
    }
}

