/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hawkular.alerts.actions.tests.CommonData;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class WebRequestsResponseTimeData
extends CommonData {
    public static Trigger trigger;
    public static ThresholdCondition firingCondition;
    public static ThresholdCondition autoResolveCondition;
    public static Dampening firingDampening;

    public static Alert getOpenAlert() {
        ArrayList satisfyingEvals = new ArrayList();
        Data rtBadData1 = Data.forNumeric((String)"test-tenant", (String)firingCondition.getDataId(), (long)System.currentTimeMillis(), (Double)1900.0);
        ThresholdConditionEval eval1 = new ThresholdConditionEval(firingCondition, rtBadData1);
        HashSet<ThresholdConditionEval> evalSet1 = new HashSet<ThresholdConditionEval>();
        evalSet1.add(eval1);
        satisfyingEvals.add(evalSet1);
        Data rtBadData2 = Data.forNumeric((String)"test-tenant", (String)firingCondition.getDataId(), (long)(System.currentTimeMillis() + 5000L), (Double)1800.0);
        ThresholdConditionEval eval2 = new ThresholdConditionEval(firingCondition, rtBadData2);
        HashSet<ThresholdConditionEval> evalSet2 = new HashSet<ThresholdConditionEval>();
        evalSet2.add(eval2);
        satisfyingEvals.add(evalSet2);
        Alert openAlert = new Alert(trigger.getTenantId(), trigger, firingDampening, satisfyingEvals);
        return openAlert;
    }

    public static Alert resolveAlert(Alert unresolvedAlert) {
        ArrayList resolvedEvals = new ArrayList();
        Data rtGoodData = Data.forNumeric((String)"test-tenant", (String)autoResolveCondition.getDataId(), (long)(System.currentTimeMillis() + 20000L), (Double)900.0);
        ThresholdConditionEval eval1 = new ThresholdConditionEval(autoResolveCondition, rtGoodData);
        HashSet<ThresholdConditionEval> evalSet1 = new HashSet<ThresholdConditionEval>();
        evalSet1.add(eval1);
        resolvedEvals.add(evalSet1);
        unresolvedAlert.setResolvedEvalSets(resolvedEvals);
        unresolvedAlert.setStatus(Alert.Status.RESOLVED);
        unresolvedAlert.setResolvedBy("resolve-user");
        unresolvedAlert.addNote("resolve-user", "These resolved notes are automatically generated");
        unresolvedAlert.setResolvedTime(System.currentTimeMillis());
        return unresolvedAlert;
    }

    static {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("resourceType", "App Server");
        context.put("resourceName", "thevault~Local");
        context.put("category", "Web Requests");
        String triggerId = "thevault~local-web-request-response-time-trigger";
        String triggerDescription = "Web Request Response Time for thevault~Local";
        String dataId = "thevault~local-web-request-response-time-data-id";
        trigger = new Trigger("test-tenant", triggerId, triggerDescription, context);
        firingCondition = new ThresholdCondition("test-tenant", trigger.getId(), Mode.FIRING, dataId, ThresholdCondition.Operator.GT, Double.valueOf(1000.0));
        firingCondition.getContext().put("description", "Response Time");
        firingCondition.getContext().put("unit", "ms");
        autoResolveCondition = new ThresholdCondition("test-tenant", trigger.getId(), Mode.AUTORESOLVE, dataId, ThresholdCondition.Operator.LTE, Double.valueOf(1000.0));
        autoResolveCondition.getContext().put("description", "Response Time");
        autoResolveCondition.getContext().put("unit", "ms");
        firingDampening = Dampening.forStrictTimeout((String)"test-tenant", (String)trigger.getId(), (Mode)Mode.FIRING, (long)10000L);
    }
}

