/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hawkular.alerts.actions.tests.CommonData;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class WebContainerCurrentThreadsData
extends CommonData {
    public static Trigger trigger;
    public static ThresholdRangeCondition firingCondition;
    public static ThresholdRangeCondition autoResolveCondition;
    public static Dampening firingDampening;

    public static Alert getOpenAlert() {
        ArrayList satisfyingEvals = new ArrayList();
        Data rtBadData1 = Data.forNumeric((String)firingCondition.getDataId(), (long)System.currentTimeMillis(), (Double)5010.0);
        ThresholdRangeConditionEval eval1 = new ThresholdRangeConditionEval(firingCondition, rtBadData1);
        HashSet<ThresholdRangeConditionEval> evalSet1 = new HashSet<ThresholdRangeConditionEval>();
        evalSet1.add(eval1);
        satisfyingEvals.add(evalSet1);
        Data rtBadData2 = Data.forNumeric((String)firingCondition.getDataId(), (long)(System.currentTimeMillis() + 5000L), (Double)5014.0);
        ThresholdRangeConditionEval eval2 = new ThresholdRangeConditionEval(firingCondition, rtBadData2);
        HashSet<ThresholdRangeConditionEval> evalSet2 = new HashSet<ThresholdRangeConditionEval>();
        evalSet2.add(eval2);
        satisfyingEvals.add(evalSet2);
        Alert openAlert = new Alert(trigger.getTenantId(), trigger, firingDampening, satisfyingEvals);
        return openAlert;
    }

    public static Alert resolveAlert(Alert unresolvedAlert) {
        ArrayList resolvedEvals = new ArrayList();
        Data rtGoodData = Data.forNumeric((String)autoResolveCondition.getDataId(), (long)(System.currentTimeMillis() + 20000L), (Double)1000.0);
        ThresholdRangeConditionEval eval1 = new ThresholdRangeConditionEval(autoResolveCondition, rtGoodData);
        HashSet<ThresholdRangeConditionEval> evalSet1 = new HashSet<ThresholdRangeConditionEval>();
        evalSet1.add(eval1);
        resolvedEvals.add(evalSet1);
        unresolvedAlert.setResolvedEvalSets(resolvedEvals);
        unresolvedAlert.setStatus(Alert.Status.RESOLVED);
        unresolvedAlert.setResolvedBy("resolve-user");
        unresolvedAlert.addNote("resolve-user", "These resolved notes are automatically generated");
        unresolvedAlert.setResolvedTime(System.currentTimeMillis());
        return unresolvedAlert;
    }

    static {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("resourceType", "App Server");
        context.put("resourceName", "thevault~Local");
        context.put("category", "Web Container");
        String triggerId = "thevault~local-container-current-threads-trigger";
        String triggerDescription = "Current Container Threads for thevault~Local";
        String dataId = "thevault~local-container-current-threads-data-id";
        trigger = new Trigger("test-tenant", triggerId, triggerDescription, context);
        firingCondition = new ThresholdRangeCondition(trigger.getId(), Mode.FIRING, dataId, ThresholdRangeCondition.Operator.INCLUSIVE, ThresholdRangeCondition.Operator.INCLUSIVE, Double.valueOf(200.0), Double.valueOf(5000.0), false);
        firingCondition.setTenantId("test-tenant");
        firingCondition.getContext().put("description", "Current Threads");
        firingCondition.getContext().put("unit", "threads");
        autoResolveCondition = new ThresholdRangeCondition(trigger.getId(), Mode.FIRING, dataId, ThresholdRangeCondition.Operator.EXCLUSIVE, ThresholdRangeCondition.Operator.EXCLUSIVE, Double.valueOf(200.0), Double.valueOf(5000.0), true);
        autoResolveCondition.setTenantId("test-tenant");
        autoResolveCondition.getContext().put("description", "Current Threads");
        autoResolveCondition.getContext().put("unit", "threads");
        firingDampening = Dampening.forStrictTimeout((String)trigger.getId(), (Mode)Mode.FIRING, (long)10000L);
        firingDampening.setTenantId("test-tenant");
    }
}

