/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hawkular.alerts.actions.tests.CommonData;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.Data;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.trigger.Match;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class MultipleAllJvmData
extends CommonData {
    public static Trigger trigger;
    public static Condition[] firingConditions;
    public static Condition[] autoResolveConditions;
    public static Dampening firingDampening;

    public static Alert getOpenAlert() {
        ArrayList satisfyingEvals = new ArrayList();
        Data rtBadData1a = Data.forNumeric((String)firingConditions[0].getDataId(), (long)System.currentTimeMillis(), (Double)1900.0);
        ThresholdConditionEval eval1a = new ThresholdConditionEval((ThresholdCondition)firingConditions[0], rtBadData1a);
        HashSet<Object> evalSet1 = new HashSet<Object>();
        evalSet1.add(eval1a);
        Data rtBadData1b = Data.forNumeric((String)firingConditions[1].getDataId(), (long)System.currentTimeMillis(), (Double)315.0);
        ThresholdRangeConditionEval eval1b = new ThresholdRangeConditionEval((ThresholdRangeCondition)firingConditions[1], rtBadData1b);
        evalSet1.add(eval1b);
        Data rtBadData1c = Data.forNumeric((String)firingConditions[2].getDataId(), (long)System.currentTimeMillis(), (Double)215.0);
        ThresholdRangeConditionEval eval1c = new ThresholdRangeConditionEval((ThresholdRangeCondition)firingConditions[2], rtBadData1c);
        evalSet1.add(eval1c);
        satisfyingEvals.add(evalSet1);
        Data rtBadData2a = Data.forNumeric((String)firingConditions[0].getDataId(), (long)(System.currentTimeMillis() + 5000L), (Double)1800.0);
        ThresholdConditionEval eval2a = new ThresholdConditionEval((ThresholdCondition)firingConditions[0], rtBadData2a);
        HashSet<Object> evalSet2 = new HashSet<Object>();
        evalSet2.add(eval2a);
        Data rtBadData2b = Data.forNumeric((String)firingConditions[1].getDataId(), (long)(System.currentTimeMillis() + 5000L), (Double)350.0);
        ThresholdRangeConditionEval eval2b = new ThresholdRangeConditionEval((ThresholdRangeCondition)firingConditions[1], rtBadData2b);
        evalSet2.add(eval2b);
        Data rtBadData2c = Data.forNumeric((String)firingConditions[2].getDataId(), (long)(System.currentTimeMillis() + 5000L), (Double)250.0);
        ThresholdRangeConditionEval eval2c = new ThresholdRangeConditionEval((ThresholdRangeCondition)firingConditions[2], rtBadData2c);
        evalSet2.add(eval2c);
        satisfyingEvals.add(evalSet2);
        Alert openAlert = new Alert(trigger.getTenantId(), trigger, firingDampening, satisfyingEvals);
        return openAlert;
    }

    public static Alert resolveAlert(Alert unresolvedAlert) {
        ArrayList resolvedEvals = new ArrayList();
        Data rtGoodDataA = Data.forNumeric((String)autoResolveConditions[0].getDataId(), (long)(System.currentTimeMillis() + 20000L), (Double)900.0);
        ThresholdConditionEval eval1A = new ThresholdConditionEval((ThresholdCondition)autoResolveConditions[0], rtGoodDataA);
        HashSet<Object> evalSet1 = new HashSet<Object>();
        evalSet1.add(eval1A);
        Data rtGoodDataB = Data.forNumeric((String)autoResolveConditions[1].getDataId(), (long)(System.currentTimeMillis() + 20000L), (Double)150.0);
        ThresholdRangeConditionEval eval1B = new ThresholdRangeConditionEval((ThresholdRangeCondition)autoResolveConditions[1], rtGoodDataB);
        evalSet1.add(eval1B);
        Data rtGoodData = Data.forNumeric((String)autoResolveConditions[2].getDataId(), (long)(System.currentTimeMillis() + 20000L), (Double)125.0);
        ThresholdRangeConditionEval eval1C = new ThresholdRangeConditionEval((ThresholdRangeCondition)autoResolveConditions[2], rtGoodData);
        evalSet1.add(eval1C);
        resolvedEvals.add(evalSet1);
        unresolvedAlert.setResolvedEvalSets(resolvedEvals);
        unresolvedAlert.setStatus(Alert.Status.RESOLVED);
        unresolvedAlert.setResolvedBy("resolve-user");
        unresolvedAlert.addNote("resolve-user", "These resolved notes are automatically generated");
        unresolvedAlert.setResolvedTime(System.currentTimeMillis());
        return unresolvedAlert;
    }

    static {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("resourceType", "App Server");
        context.put("resourceName", "thevault~Local");
        context.put("category", "JVM");
        firingConditions = new Condition[3];
        autoResolveConditions = new Condition[3];
        String[] dataId = new String[3];
        String triggerId = "thevault~local-web-multiple-jvm-metrics-trigger";
        String triggerDescription = "Multiple JVM Metrics for thevault~Local";
        dataId[0] = "thevault~local-jvm-garbage-collection-data-id";
        dataId[1] = "thevault~local-jvm-heap-usage-data-id";
        dataId[2] = "thevault~local-jvm-non-heap-usage-data-id";
        trigger = new Trigger("test-tenant", triggerId, triggerDescription, context);
        trigger.setFiringMatch(Match.ALL);
        trigger.setAutoResolveMatch(Match.ALL);
        MultipleAllJvmData.firingConditions[0] = new ThresholdCondition(trigger.getId(), Mode.FIRING, 3, 1, dataId[0], ThresholdCondition.Operator.GT, Double.valueOf(1000.0));
        firingConditions[0].setTenantId("test-tenant");
        firingConditions[0].getContext().put("description", "GC Duration");
        firingConditions[0].getContext().put("unit", "ms");
        MultipleAllJvmData.autoResolveConditions[0] = new ThresholdCondition(trigger.getId(), Mode.AUTORESOLVE, 3, 1, dataId[0], ThresholdCondition.Operator.LTE, Double.valueOf(1000.0));
        autoResolveConditions[0].setTenantId("test-tenant");
        autoResolveConditions[0].getContext().put("description", "GC Duration");
        autoResolveConditions[0].getContext().put("unit", "ms");
        MultipleAllJvmData.firingConditions[1] = new ThresholdRangeCondition(trigger.getId(), Mode.FIRING, 3, 2, dataId[1], ThresholdRangeCondition.Operator.INCLUSIVE, ThresholdRangeCondition.Operator.INCLUSIVE, Double.valueOf(100.0), Double.valueOf(300.0), false);
        firingConditions[1].setTenantId("test-tenant");
        firingConditions[1].getContext().put("description", "Heap Usage");
        firingConditions[1].getContext().put("unit", "Mb");
        MultipleAllJvmData.autoResolveConditions[1] = new ThresholdRangeCondition(trigger.getId(), Mode.FIRING, 3, 2, dataId[1], ThresholdRangeCondition.Operator.EXCLUSIVE, ThresholdRangeCondition.Operator.EXCLUSIVE, Double.valueOf(100.0), Double.valueOf(300.0), true);
        autoResolveConditions[1].setTenantId("test-tenant");
        autoResolveConditions[1].getContext().put("description", "Heap Usage");
        autoResolveConditions[1].getContext().put("unit", "Mb");
        MultipleAllJvmData.firingConditions[2] = new ThresholdRangeCondition(trigger.getId(), Mode.FIRING, 3, 3, dataId[2], ThresholdRangeCondition.Operator.INCLUSIVE, ThresholdRangeCondition.Operator.INCLUSIVE, Double.valueOf(100.0), Double.valueOf(300.0), false);
        firingConditions[2].setTenantId("test-tenant");
        firingConditions[2].getContext().put("description", "Non Heap Usage");
        firingConditions[2].getContext().put("unit", "Mb");
        MultipleAllJvmData.autoResolveConditions[2] = new ThresholdRangeCondition(trigger.getId(), Mode.FIRING, 3, 3, dataId[2], ThresholdRangeCondition.Operator.EXCLUSIVE, ThresholdRangeCondition.Operator.EXCLUSIVE, Double.valueOf(100.0), Double.valueOf(200.0), true);
        autoResolveConditions[2].setTenantId("test-tenant");
        autoResolveConditions[2].getContext().put("description", "Non Heap Usage");
        autoResolveConditions[2].getContext().put("unit", "Mb");
        firingDampening = Dampening.forStrictTimeout((String)trigger.getId(), (Mode)Mode.FIRING, (long)10000L);
        firingDampening.setTenantId("test-tenant");
    }
}

