/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.tests;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import org.hawkular.alerts.actions.tests.CommonData;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.data.NumericData;
import org.hawkular.alerts.api.model.trigger.Mode;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class JvmGarbageCollectionData
extends CommonData {
    public static Trigger trigger;
    public static ThresholdCondition firingCondition;
    public static ThresholdCondition autoResolveCondition;
    public static Dampening firingDampening;

    public static Alert getOpenAlert() {
        ArrayList satisfyingEvals = new ArrayList();
        NumericData rtBadData1 = new NumericData(firingCondition.getDataId(), System.currentTimeMillis(), Double.valueOf(1900.0));
        ThresholdConditionEval eval1 = new ThresholdConditionEval(firingCondition, rtBadData1);
        HashSet<ThresholdConditionEval> evalSet1 = new HashSet<ThresholdConditionEval>();
        evalSet1.add(eval1);
        satisfyingEvals.add(evalSet1);
        NumericData rtBadData2 = new NumericData(firingCondition.getDataId(), System.currentTimeMillis() + 5000L, Double.valueOf(1800.0));
        ThresholdConditionEval eval2 = new ThresholdConditionEval(firingCondition, rtBadData2);
        HashSet<ThresholdConditionEval> evalSet2 = new HashSet<ThresholdConditionEval>();
        evalSet2.add(eval2);
        satisfyingEvals.add(evalSet2);
        Alert openAlert = new Alert(trigger.getTenantId(), trigger.getId(), trigger.getSeverity(), satisfyingEvals);
        openAlert.setTrigger(trigger);
        openAlert.setDampening(firingDampening);
        openAlert.setContext(trigger.getContext());
        return openAlert;
    }

    public static Alert resolveAlert(Alert unresolvedAlert) {
        ArrayList resolvedEvals = new ArrayList();
        NumericData rtGoodData = new NumericData(autoResolveCondition.getDataId(), System.currentTimeMillis() + 20000L, Double.valueOf(900.0));
        ThresholdConditionEval eval1 = new ThresholdConditionEval(autoResolveCondition, rtGoodData);
        HashSet<ThresholdConditionEval> evalSet1 = new HashSet<ThresholdConditionEval>();
        evalSet1.add(eval1);
        resolvedEvals.add(evalSet1);
        unresolvedAlert.setResolvedEvalSets(resolvedEvals);
        unresolvedAlert.setStatus(Alert.Status.RESOLVED);
        unresolvedAlert.setResolvedBy("resolve-user");
        unresolvedAlert.addNote("resolve-user", "These resolved notes are automatically generated");
        unresolvedAlert.setResolvedTime(System.currentTimeMillis());
        return unresolvedAlert;
    }

    static {
        HashMap<String, String> context = new HashMap<String, String>();
        context.put("resourceType", "App Server");
        context.put("resourceName", "thevault~Local");
        context.put("category", "JVM");
        String triggerId = "thevault~local-jvm-garbage-collection-trigger";
        String triggerDescription = "JVM Garbage Collection for thevault~Local";
        String dataId = "thevault~local-jvm-garbage-collection-data-id";
        trigger = new Trigger("test-tenant", triggerId, triggerDescription, context);
        firingCondition = new ThresholdCondition(trigger.getId(), Mode.FIRING, dataId, ThresholdCondition.Operator.GT, Double.valueOf(1000.0));
        firingCondition.setTenantId("test-tenant");
        firingCondition.getContext().put("description", "GC Duration");
        firingCondition.getContext().put("unit", "ms");
        autoResolveCondition = new ThresholdCondition(trigger.getId(), Mode.AUTORESOLVE, dataId, ThresholdCondition.Operator.LTE, Double.valueOf(1000.0));
        autoResolveCondition.setTenantId("test-tenant");
        autoResolveCondition.getContext().put("description", "GC Duration");
        autoResolveCondition.getContext().put("unit", "ms");
        firingDampening = Dampening.forStrictTimeout((String)trigger.getId(), (Mode)Mode.FIRING, (long)10000L);
        firingDampening.setTenantId("test-tenant");
    }
}

