/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.pagerduty.listener;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.InstanceCreator;
import com.squareup.pagerduty.incidents.NotifyResult;
import com.squareup.pagerduty.incidents.PagerDuty;
import com.squareup.pagerduty.incidents.Trigger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import javax.annotation.PostConstruct;
import javax.ejb.ActivationConfigProperty;
import javax.ejb.MessageDriven;
import javax.jms.MessageListener;
import org.hawkular.alerts.actions.api.log.MsgLogger;
import org.hawkular.alerts.actions.api.model.ActionMessage;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.condition.Alert;
import org.hawkular.bus.common.consumer.BasicMessageListener;
import retrofit.RestAdapter;
import retrofit.converter.Converter;
import retrofit.converter.GsonConverter;

@MessageDriven(messageListenerInterface=MessageListener.class, activationConfig={@ActivationConfigProperty(propertyName="destinationType", propertyValue="javax.jms.Topic"), @ActivationConfigProperty(propertyName="destination", propertyValue="HawkularAlertsActionsTopic"), @ActivationConfigProperty(propertyName="messageSelector", propertyValue="actionPlugin like 'pagerduty'")})
public class PagerDutyListener
extends BasicMessageListener<ActionMessage> {
    static final String API_KEY_PROPERTY = "org.hawkular.actions.pagerduty.api.key";
    static final String API_KEY = System.getProperty("org.hawkular.actions.pagerduty.api.key");
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    PagerDuty pagerDuty;

    @PostConstruct
    void setup() {
        if (this.isBlank(API_KEY)) {
            String msg = "Configure " + API_KEY;
            this.msgLog.errorCannotBeStarted("pagerduty", msg);
            return;
        }
        try {
            InstanceCreator notifyResultCreator = this.buildNotifyResultCreator();
            Gson gson = new GsonBuilder().registerTypeAdapter(NotifyResult.class, (Object)notifyResultCreator).create();
            RestAdapter restAdapter = new RestAdapter.Builder().setEndpoint("https://events.pagerduty.com").setConverter((Converter)new GsonConverter(gson)).build();
            this.pagerDuty = PagerDuty.create((String)API_KEY, (RestAdapter)restAdapter);
        }
        catch (Exception e) {
            this.msgLog.errorCannotBeStarted("pagerduty", e.getLocalizedMessage());
        }
    }

    InstanceCreator<NotifyResult> buildNotifyResultCreator() {
        NotifyResult notifyResult;
        Constructor constructor;
        try {
            constructor = NotifyResult.class.getDeclaredConstructor(String.class, String.class, String.class);
            if (!constructor.isAccessible()) {
                constructor.setAccessible(true);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Pager Duty Java client is not compatible", e);
        }
        try {
            notifyResult = (NotifyResult)constructor.newInstance("1", "2", "3");
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new RuntimeException("Pager Duty Java client is not compatible", e);
        }
        if (!("1".equals(notifyResult.status()) && "2".equals(notifyResult.message()) && "3".equals(notifyResult.incidentKey()))) {
            throw new RuntimeException("Pager Duty Java client is not compatible");
        }
        return type -> {
            try {
                return (NotifyResult)constructor.newInstance("", "", "");
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        };
    }

    private boolean isBlank(String value) {
        return value == null || value.trim().isEmpty();
    }

    private String prepareMessage(ActionMessage msg) {
        String preparedMsg = null;
        if (msg != null) {
            Alert alert;
            Alert alert2 = alert = msg.getAlert() != null ? (Alert)JsonUtil.fromJson((String)msg.getAlert(), Alert.class) : null;
            if (alert != null) {
                preparedMsg = "Alert : " + alert.getTriggerId() + " at " + alert.getCtime() + " -- Severity: " + alert.getSeverity().toString();
            } else if (msg.getMessage() != null) {
                preparedMsg = msg.getMessage();
            } else {
                preparedMsg = "Message received without data at " + System.currentTimeMillis();
                this.msgLog.warnMessageReceivedWithoutPayload("pagerduty");
            }
        }
        return preparedMsg;
    }

    protected void onBasicMessage(ActionMessage msg) {
        this.msgLog.infoActionReceived("pagerduty", msg.toString());
        if (this.pagerDuty == null) {
            this.msgLog.errorCannotSendMessage("pagerduty", "Plugin is not started");
            return;
        }
        Trigger trigger = new Trigger.Builder(this.prepareMessage(msg)).build();
        NotifyResult result = this.pagerDuty.notify(trigger);
        if (!"success".equals(result.status())) {
            this.msgLog.errorCannotSendMessage("pagerduty", result.message());
        }
    }
}

