/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.email;

import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.email.PluginMessageDescription;
import org.jboss.logging.Logger;

public class EmailTemplate {
    private final Logger log = Logger.getLogger(EmailTemplate.class);
    public static final String DEFAULT_TEMPLATE_PLAIN = "template.plain.default.ftl";
    public static final String DEFAULT_TEMPLATE_HTML = "template.html.default.ftl";
    public static final Locale DEFAULT_LOCALE = new Locale("en", "US");
    Configuration ftlCfg = new Configuration();
    Template ftlTemplate;
    Template ftlTemplatePlain;
    Template ftlTemplateHtml;

    public EmailTemplate() {
        try {
            File fileDir;
            String templatesDir = System.getenv("HAWKULAR_ALERTS_TEMPLATES");
            templatesDir = templatesDir == null ? System.getProperty("hawkular.alerts.templates") : templatesDir;
            boolean templatesFromDir = false;
            if (templatesDir != null && (fileDir = new File(templatesDir)).exists()) {
                this.ftlCfg.setDirectoryForTemplateLoading(fileDir);
                templatesFromDir = true;
            }
            if (!templatesFromDir) {
                this.ftlCfg.setClassForTemplateLoading(this.getClass(), "/");
            }
            this.ftlTemplatePlain = this.ftlCfg.getTemplate(DEFAULT_TEMPLATE_PLAIN, DEFAULT_LOCALE);
            this.ftlTemplateHtml = this.ftlCfg.getTemplate(DEFAULT_TEMPLATE_HTML, DEFAULT_LOCALE);
        }
        catch (IOException e) {
            this.log.debug((Object)e.getMessage(), (Throwable)e);
            throw new RuntimeException("Cannot initialize templates on email plugin: " + e.getMessage());
        }
    }

    public Map<String, String> processTemplate(ActionMessage msg) throws Exception {
        String html;
        String plain;
        String templateLocale;
        HashMap<String, String> emailProcessed = new HashMap<String, String>();
        PluginMessageDescription pmDesc = new PluginMessageDescription(msg);
        emailProcessed.put("emailSubject", pmDesc.getEmailSubject());
        String string = templateLocale = pmDesc.getProps() != null ? pmDesc.getProps().get("template.locale") : null;
        if (templateLocale != null) {
            plain = pmDesc.getProps().get("template.plain." + templateLocale);
            html = pmDesc.getProps().get("template.html." + templateLocale);
        } else {
            plain = pmDesc.getProps() != null ? pmDesc.getProps().get("template.plain") : null;
            html = pmDesc.getProps() != null ? pmDesc.getProps().get("template.html") : null;
        }
        StringWriter writerPlain = new StringWriter();
        StringWriter writerHtml = new StringWriter();
        if (plain != null && !plain.isEmpty()) {
            StringReader plainReader = new StringReader(plain);
            this.ftlTemplate = new Template("plainTemplate", (Reader)plainReader, this.ftlCfg);
            this.ftlTemplate.process((Object)pmDesc, (Writer)writerPlain);
        } else {
            this.ftlTemplatePlain.process((Object)pmDesc, (Writer)writerPlain);
        }
        if (html != null && !html.isEmpty()) {
            StringReader htmlReader = new StringReader(html);
            this.ftlTemplate = new Template("htmlTemplate", (Reader)htmlReader, this.ftlCfg);
            this.ftlTemplate.process((Object)pmDesc, (Writer)writerHtml);
        } else {
            this.ftlTemplateHtml.process((Object)pmDesc, (Writer)writerHtml);
        }
        writerPlain.flush();
        writerPlain.close();
        emailProcessed.put("emailBodyPlain", writerPlain.toString());
        writerHtml.flush();
        writerHtml.close();
        emailProcessed.put("emailBodyHtml", writerHtml.toString());
        return emailProcessed;
    }
}

