/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.email;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.actions.api.ActionPluginListener;
import org.hawkular.alerts.actions.api.ActionPluginSender;
import org.hawkular.alerts.actions.api.ActionResponseMessage;
import org.hawkular.alerts.actions.api.MsgLogger;
import org.hawkular.alerts.actions.api.Plugin;
import org.hawkular.alerts.actions.api.Sender;
import org.hawkular.alerts.actions.email.EmailMimeMessage;
import org.hawkular.alerts.actions.email.EmailTemplate;
import org.hawkular.alerts.api.json.JsonUtil;
import org.hawkular.alerts.api.model.action.Action;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.jboss.logging.Logger;

@Plugin(name="email")
public class EmailPlugin
implements ActionPluginListener {
    public static final String PLUGIN_NAME = "email";
    public static final String MAIL_SESSION_OFFLINE = "org.hawkular.alerts.actions.email.session.offline";
    public static final String MESSAGE_ID = "Message-ID";
    public static final String IN_REPLY_TO = "in-reply-to";
    public static final String DEFAULT_FROM_PROPERTY = "org.hawkular.alerts.actions.email.default.from";
    public static final String DEFAULT_FROM = System.getProperty("org.hawkular.alerts.actions.email.default.from", "noreply@hawkular.org");
    public static final String DEFAULT_FROM_NAME_PROPERTY = "org.hawkular.alerts.actions.email.default.from-name";
    public static final String DEFAULT_FROM_NAME = System.getProperty("org.hawkular.alerts.actions.email.default.from-name", "Hawkular");
    public static final String HAWKULAR_BASE_URL = "HAWKULAR_BASE_URL";
    public static final String DEFAULT_HAWKULAR_BASE_URL = System.getenv("HAWKULAR_BASE_URL") == null ? "http://localhost:8080/" : System.getenv("HAWKULAR_BASE_URL");
    public static final String HAWKULAR_ALERTS_TEMPLATES = "HAWKULAR_ALERTS_TEMPLATES";
    public static final String HAWKULAR_ALERTS_TEMPLATES_PROPERY = "hawkular.alerts.templates";
    public static final String PROP_FROM = "from";
    public static final String PROP_FROM_NAME = "from-name";
    public static final String PROP_TO = "to";
    public static final String PROP_CC = "cc";
    public static final String PROP_TEMPLATE_HAWKULAR_URL = "template.hawkular.url";
    public static final String PROP_TEMPLATE_LOCALE = "template.locale";
    public static final String PROP_TEMPLATE_PLAIN = "template.plain";
    public static final String PROP_TEMPLATE_HTML = "template.html";
    private final MsgLogger msgLog = MsgLogger.LOGGER;
    private final Logger log = Logger.getLogger(EmailPlugin.class);
    Map<String, String> defaultProperties = new HashMap<String, String>();
    Session mailSession;
    EmailTemplate emailTemplate;
    @Sender
    ActionPluginSender sender;
    private static final String MESSAGE_PROCESSED = "PROCESSED";
    private static final String MESSAGE_FAILED = "FAILED";

    public EmailPlugin() {
        this.defaultProperties.put(PROP_FROM, DEFAULT_FROM);
        this.defaultProperties.put(PROP_FROM_NAME, DEFAULT_FROM_NAME);
        this.defaultProperties.put(PROP_TO, "");
        this.defaultProperties.put(PROP_CC, "");
        this.defaultProperties.put(PROP_TEMPLATE_HAWKULAR_URL, DEFAULT_HAWKULAR_BASE_URL);
        this.defaultProperties.put(PROP_TEMPLATE_PLAIN, "");
        this.defaultProperties.put(PROP_TEMPLATE_HTML, "");
        this.emailTemplate = new EmailTemplate();
    }

    public void setSender(ActionPluginSender sender) {
        this.sender = sender;
    }

    private void initMailSession(String tenantId) {
        boolean offLine;
        boolean bl = offLine = System.getProperty(MAIL_SESSION_OFFLINE) != null;
        if (!offLine) {
            Properties systemProperties = System.getProperties();
            Properties emailProperties = new Properties();
            for (String property : systemProperties.stringPropertyNames()) {
                if (!this.isEmpty(tenantId) && property.startsWith(tenantId + ".mail.")) {
                    emailProperties.put(property.substring(tenantId.length() + 1), System.getProperty(property));
                    continue;
                }
                if (!property.startsWith("mail.")) continue;
                emailProperties.put(property, System.getProperty(property));
            }
            if (emailProperties.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"No mail.* properties found, setting default mail server to localhost:25");
                }
                emailProperties.setProperty("mail.smtp.host", "localhost");
                emailProperties.setProperty("mail.smtp.port", "25");
            }
            this.mailSession = Session.getInstance((Properties)emailProperties);
        }
    }

    public Set<String> getProperties() {
        return this.defaultProperties.keySet();
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    private void sendResult(Action action) {
        if (this.sender == null) {
            throw new IllegalStateException("ActionPluginSender is not present in the plugin");
        }
        if (action == null) {
            throw new IllegalStateException("Action to update result must be not null");
        }
        ActionResponseMessage newMessage = this.sender.createMessage(ActionResponseMessage.Operation.RESULT);
        newMessage.getPayload().put("action", JsonUtil.toJson((Object)action));
        try {
            this.sender.send(newMessage);
        }
        catch (Exception e) {
            this.log.error((Object)"Error sending ActionResponseMessage", (Throwable)e);
        }
    }

    public void process(ActionMessage msg) throws Exception {
        if (msg == null || msg.getAction() == null) {
            this.msgLog.warnMessageReceivedWithoutPayload(PLUGIN_NAME);
        }
        try {
            String tenantId = msg.getAction() != null ? msg.getAction().getTenantId() : null;
            this.initMailSession(tenantId);
            Message message = this.createMimeMessage(msg);
            Transport.send((Message)message);
            this.msgLog.infoActionReceived(PLUGIN_NAME, msg.toString());
            Action successAction = msg.getAction();
            successAction.setResult(MESSAGE_PROCESSED);
            this.sendResult(successAction);
        }
        catch (Exception e) {
            this.msgLog.errorCannotProcessMessage(PLUGIN_NAME, e.getMessage());
            Action failedAction = msg.getAction();
            failedAction.setResult(MESSAGE_FAILED);
            this.sendResult(failedAction);
        }
    }

    protected Message createMimeMessage(ActionMessage msg) throws Exception {
        Map<String, String> emailProcessed;
        String subject;
        String ccs;
        String to;
        EmailMimeMessage email = new EmailMimeMessage(this.mailSession);
        Map props = msg.getAction().getProperties();
        if (null == props || props.isEmpty()) {
            this.msgLog.warn((Object)"Properties empty on plugin email");
        }
        Event event = msg.getAction() != null ? msg.getAction().getEvent() : null;
        Alert alert = null != event && event instanceof Alert ? (Alert)event : null;
        Alert.Status status = alert != null && alert.getStatus() != null ? alert.getStatus() : Alert.Status.OPEN;
        String statusStr = status.name().toLowerCase();
        String from = (String)props.get("from." + statusStr);
        from = from == null ? (String)props.get(PROP_FROM) : from;
        from = from == null ? DEFAULT_FROM : from;
        String fromName = (String)props.get("from-name." + statusStr);
        fromName = fromName == null ? (String)props.get(PROP_FROM_NAME) : fromName;
        fromName = fromName == null ? DEFAULT_FROM_NAME : fromName;
        email.setFrom((Address)new InternetAddress(from, fromName));
        if (alert != null && alert.getStatus() != null) {
            if (alert.getStatus().equals((Object)Alert.Status.OPEN)) {
                email.setSentDate(new Date(alert.getCtime()));
            } else if (alert.getStatus().equals((Object)Alert.Status.ACKNOWLEDGED)) {
                email.setSentDate(new Date(alert.getLastAckTime()));
            } else {
                email.setSentDate(new Date(alert.getLastResolvedTime()));
            }
        } else {
            email.setSentDate(new Date());
        }
        if (alert != null) {
            email.addHeader(MESSAGE_ID, alert.getAlertId());
            if (alert.getStatus() != null && !alert.getStatus().equals((Object)Alert.Status.OPEN)) {
                email.addHeader(IN_REPLY_TO, alert.getAlertId());
            }
        }
        String string = to = (to = (String)props.get("to." + statusStr)) == null ? (String)props.get(PROP_TO) : to;
        if (to != null && !to.isEmpty()) {
            InternetAddress toAddress = new InternetAddress(to);
            email.addRecipient(Message.RecipientType.TO, (Address)toAddress);
        }
        String string2 = ccs = (ccs = (String)props.get("cc." + statusStr)) == null ? (String)props.get(PROP_CC) : ccs;
        if (ccs != null && !ccs.isEmpty()) {
            String[] multipleCc;
            for (String cc : multipleCc = ccs.split(",")) {
                InternetAddress toAddress = new InternetAddress(cc);
                email.addRecipient(Message.RecipientType.CC, (Address)toAddress);
            }
        }
        if (null != (subject = (emailProcessed = this.emailTemplate.processTemplate(msg)).get("emailSubject")) && !subject.isEmpty()) {
            email.setSubject(subject);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Subject not found processing email on message: " + msg));
        }
        String plain = emailProcessed.get("emailBodyPlain");
        String html = emailProcessed.get("emailBodyHtml");
        if (plain != null && html != null) {
            MimeBodyPart text = new MimeBodyPart();
            text.setContent((Object)plain, "text/plain");
            MimeBodyPart rich = new MimeBodyPart();
            rich.setContent((Object)html, "text/html");
            MimeMultipart multipart = new MimeMultipart("alternative");
            multipart.addBodyPart((BodyPart)rich);
            multipart.addBodyPart((BodyPart)text);
            email.setContent((Multipart)multipart);
        }
        return email;
    }

    private boolean isEmpty(String s) {
        return s == null || s.isEmpty();
    }
}

