/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.alerts.actions.email;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.hawkular.alerts.actions.api.ActionMessage;
import org.hawkular.alerts.api.model.condition.AvailabilityCondition;
import org.hawkular.alerts.api.model.condition.AvailabilityConditionEval;
import org.hawkular.alerts.api.model.condition.CompareCondition;
import org.hawkular.alerts.api.model.condition.CompareConditionEval;
import org.hawkular.alerts.api.model.condition.Condition;
import org.hawkular.alerts.api.model.condition.ConditionEval;
import org.hawkular.alerts.api.model.condition.EventCondition;
import org.hawkular.alerts.api.model.condition.EventConditionEval;
import org.hawkular.alerts.api.model.condition.ExternalCondition;
import org.hawkular.alerts.api.model.condition.ExternalConditionEval;
import org.hawkular.alerts.api.model.condition.StringCondition;
import org.hawkular.alerts.api.model.condition.StringConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdCondition;
import org.hawkular.alerts.api.model.condition.ThresholdConditionEval;
import org.hawkular.alerts.api.model.condition.ThresholdRangeCondition;
import org.hawkular.alerts.api.model.condition.ThresholdRangeConditionEval;
import org.hawkular.alerts.api.model.dampening.Dampening;
import org.hawkular.alerts.api.model.event.Alert;
import org.hawkular.alerts.api.model.event.Event;
import org.hawkular.alerts.api.model.trigger.Trigger;

public class PluginMessageDescription {
    public static final String CONTEXT_PROPERTY_RESOURCE_TYPE = "resourceType";
    public static final String CONTEXT_PROPERTY_RESOURCE_NAME = "resourceName";
    public static final String CONTEXT_PROPERTY_UNIT = "unit";
    public static final String CONTEXT_PROPERTY_DESCRIPTION = "description";
    public static final String CONTEXT_PROPERTY_DESCRIPTION2 = "description2";
    private Event event;
    private Alert alert;
    private String status;
    private Trigger trigger;
    private String triggerDescription;
    private Dampening dampening;
    private String dampeningDescription;
    private Map<String, String> props;
    private String emailSubject;
    private int numConditions;
    private String baseUrl;
    private DecimalFormat decimalFormat = new DecimalFormat("####0.0", new DecimalFormatSymbols(Locale.ENGLISH));
    public ConditionDescription[] conditions;

    public PluginMessageDescription(ActionMessage pm) {
        if (pm == null) {
            throw new IllegalArgumentException("PluginMessage cannot be null");
        }
        if (pm.getAction() == null) {
            throw new IllegalArgumentException("Action cannot be null on PluginMessage");
        }
        if (pm.getAction().getProperties() == null) {
            throw new IllegalArgumentException("Properties cannot be null on PluginMessage");
        }
        this.event = pm.getAction().getEvent();
        if (this.event instanceof Alert) {
            this.alert = (Alert)this.event;
        }
        this.props = pm.getAction().getProperties();
        if (this.event != null && this.event instanceof Alert) {
            Alert alert = (Alert)this.event;
            if (alert.getStatus() != null) {
                this.status = alert.getStatus().name().toLowerCase();
                this.emailSubject = "Alert [" + this.status + "] message";
            } else {
                this.emailSubject = "Alert message";
            }
        } else {
            this.emailSubject = "Event message";
        }
        if (this.event != null && this.event.getTrigger() != null) {
            this.trigger = this.event.getTrigger();
            this.triggerDescription = this.trigger.getContext() != null && !this.trigger.getContext().isEmpty() && this.trigger.getContext().containsKey(CONTEXT_PROPERTY_RESOURCE_TYPE) && this.trigger.getContext().containsKey(CONTEXT_PROPERTY_RESOURCE_NAME) ? (String)this.trigger.getContext().get(CONTEXT_PROPERTY_RESOURCE_TYPE) + " " + (String)this.trigger.getContext().get(CONTEXT_PROPERTY_RESOURCE_NAME) : this.trigger.getName();
        }
        if (this.event != null && this.event.getDampening() != null) {
            this.dampening = this.event.getDampening();
            this.dampeningDescription = this.dampeningDescription(this.dampening);
        }
        this.initConditions(this.event);
        if (this.numConditions == 1) {
            this.emailSubject = this.emailSubject + ": " + this.conditions[0].description + " ";
            if (this.triggerDescription != null) {
                this.emailSubject = this.emailSubject + "for " + this.triggerDescription;
            }
        } else if (this.triggerDescription != null) {
            this.emailSubject = this.emailSubject + "for " + this.triggerDescription;
        }
        this.baseUrl = this.props != null ? this.props.get("template.hawkular.url") : null;
        this.baseUrl = this.baseUrl == null ? System.getenv("HAWKULAR_BASE_URL") : this.baseUrl;
    }

    private String dampeningDescription(Dampening d) {
        if (d == null) {
            return null;
        }
        String description = "Alert triggered ";
        switch (d.getType()) {
            case STRICT: {
                description = description + "after " + d.getEvalTrueSetting() + " consecutive evaluations";
                break;
            }
            case RELAXED_COUNT: {
                description = description + "after " + d.getEvalTrueSetting() + " of " + d.getEvalTotalSetting() + " evaluations";
                break;
            }
            case RELAXED_TIME: {
                description = description + "after" + d.getEvalTrueSetting() + " evaluations in " + d.getEvalTimeSetting() / 1000L + " s";
                break;
            }
            case STRICT_TIME: 
            case STRICT_TIMEOUT: {
                description = description + "after " + d.getEvalTimeSetting() / 1000L + " s";
                break;
            }
            default: {
                throw new IllegalArgumentException(d.getType().name());
            }
        }
        return description;
    }

    private void initConditions(Event event) {
        this.numConditions = 0;
        if (event == null) {
            return;
        }
        if (event.getEvalSets() == null || event.getEvalSets().isEmpty()) {
            return;
        }
        HashMap<String, ConditionDescription> mapConditions = new HashMap<String, ConditionDescription>();
        int listEvals = event.getEvalSets().size();
        for (int i = 0; i < listEvals; ++i) {
            Set iEvalSet = (Set)event.getEvalSets().get(i);
            for (ConditionEval condEval : iEvalSet) {
                ConditionDescription condDesc;
                Condition condition = this.extractCondition(condEval);
                if (!mapConditions.containsKey(condition.getConditionId())) {
                    condDesc = new ConditionDescription();
                    condDesc.condition = condition;
                    condDesc.description = this.description(condition);
                    mapConditions.put(condition.getConditionId(), condDesc);
                }
                condDesc = (ConditionDescription)mapConditions.get(condition.getConditionId());
                condDesc.data.add(this.extractValue(condEval));
            }
        }
        Collection values = mapConditions.values();
        for (ConditionDescription condDesc : values.toArray(new ConditionDescription[values.size()])) {
            condDesc.average = condDesc.data.stream().reduce(0.0, (j, k) -> j + k) / (double)condDesc.data.size();
            if (!condDesc.condition.getContext().containsKey(CONTEXT_PROPERTY_UNIT)) continue;
            condDesc.averageDescription = this.decimalFormat.format(condDesc.average) + " " + (String)condDesc.condition.getContext().get(CONTEXT_PROPERTY_UNIT);
        }
    }

    private Condition extractCondition(ConditionEval conditionEval) {
        if (conditionEval == null) {
            return null;
        }
        switch (conditionEval.getType()) {
            case AVAILABILITY: {
                return ((AvailabilityConditionEval)conditionEval).getCondition();
            }
            case COMPARE: {
                return ((CompareConditionEval)conditionEval).getCondition();
            }
            case EXTERNAL: {
                return ((ExternalConditionEval)conditionEval).getCondition();
            }
            case EVENT: {
                return ((EventConditionEval)conditionEval).getCondition();
            }
            case STRING: {
                return ((StringConditionEval)conditionEval).getCondition();
            }
            case THRESHOLD: {
                return ((ThresholdConditionEval)conditionEval).getCondition();
            }
            case RANGE: {
                return ((ThresholdRangeConditionEval)conditionEval).getCondition();
            }
        }
        return null;
    }

    private Double extractValue(ConditionEval conditionEval) {
        if (conditionEval == null) {
            return 0.0;
        }
        switch (conditionEval.getType()) {
            case THRESHOLD: {
                return ((ThresholdConditionEval)conditionEval).getValue();
            }
            case RANGE: {
                return ((ThresholdRangeConditionEval)conditionEval).getValue();
            }
        }
        return 0.0;
    }

    private String description(Condition condition) {
        if (condition == null) {
            return null;
        }
        switch (condition.getType()) {
            case AVAILABILITY: {
                return this.availability((AvailabilityCondition)condition);
            }
            case COMPARE: {
                return this.compare((CompareCondition)condition);
            }
            case EXTERNAL: {
                return this.external((ExternalCondition)condition);
            }
            case EVENT: {
                return this.events((EventCondition)condition);
            }
            case STRING: {
                return this.string((StringCondition)condition);
            }
            case THRESHOLD: {
                return this.threshold((ThresholdCondition)condition);
            }
            case RANGE: {
                return this.range((ThresholdRangeCondition)condition);
            }
        }
        return null;
    }

    public String availability(AvailabilityCondition condition) {
        String description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) != null ? (String)condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) : condition.getDataId();
        AvailabilityCondition.Operator operator = condition.getOperator();
        switch (operator) {
            case DOWN: {
                description = description + " is down";
                break;
            }
            case NOT_UP: {
                description = description + " is not up";
                break;
            }
            case UP: {
                description = description + " is up";
                break;
            }
            default: {
                throw new IllegalArgumentException(operator.name());
            }
        }
        return description;
    }

    public String compare(CompareCondition condition) {
        String description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) != null ? (String)condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) : condition.getDataId();
        CompareCondition.Operator operator = condition.getOperator();
        switch (operator) {
            case LT: {
                description = description + " less than ";
                break;
            }
            case LTE: {
                description = description + " less or equals than ";
                break;
            }
            case GT: {
                description = description + " greater than ";
                break;
            }
            case GTE: {
                description = description + " greater or equals than ";
                break;
            }
            default: {
                throw new IllegalArgumentException(operator.name());
            }
        }
        if (condition.getData2Multiplier() != 1.0) {
            description = description + "( " + this.decimalFormat.format(condition.getData2Multiplier()) + " ";
        }
        description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION2) != null ? description + (String)condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION2) : description + condition.getData2Id();
        if (condition.getData2Multiplier() != 1.0) {
            description = description + " )";
        }
        return description;
    }

    public String external(ExternalCondition condition) {
        String description = "AlerterId: " + condition.getAlerterId();
        description = description + " DataId: " + condition.getDataId();
        description = description + " Expression: " + condition.getExpression();
        return description;
    }

    public String events(EventCondition condition) {
        String description = "Event on: " + condition.getDataId();
        if (condition.getExpression() != null) {
            description = description + " [" + condition.getExpression() + "]";
        }
        return description;
    }

    public String string(StringCondition condition) {
        String description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) != null ? (String)condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) : condition.getDataId();
        StringCondition.Operator operator = condition.getOperator();
        switch (operator) {
            case STARTS_WITH: {
                description = description + "starts with ";
                break;
            }
            case CONTAINS: {
                description = description + "contains ";
                break;
            }
            case ENDS_WITH: {
                description = description + "ends with ";
                break;
            }
            case EQUAL: {
                description = description + "is equal to ";
                break;
            }
            case NOT_EQUAL: {
                description = description + "is not equal to ";
                break;
            }
            case MATCH: {
                description = description + "matches to ";
                break;
            }
            default: {
                throw new IllegalArgumentException(operator.name());
            }
        }
        description = description + condition.getPattern();
        if (condition.isIgnoreCase()) {
            description = description + " (ignore case)";
        }
        return description;
    }

    public String threshold(ThresholdCondition condition) {
        String description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) != null ? (String)condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) : condition.getDataId();
        switch (condition.getOperator()) {
            case GT: {
                description = description + " greater than ";
                break;
            }
            case GTE: {
                description = description + " greater or equal than ";
                break;
            }
            case LT: {
                description = description + " less than ";
                break;
            }
            case LTE: {
                description = description + " less or equal than ";
                break;
            }
            default: {
                throw new IllegalArgumentException(condition.getOperator().name());
            }
        }
        description = description + this.decimalFormat.format(condition.getThreshold());
        description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_UNIT) != null ? description + " " + (String)condition.getContext().get(CONTEXT_PROPERTY_UNIT) : description + " (threshold)";
        return description;
    }

    public String range(ThresholdRangeCondition condition) {
        String description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) != null ? (String)condition.getContext().get(CONTEXT_PROPERTY_DESCRIPTION) : condition.getDataId();
        description = condition.isInRange() ? description + " in " : description + " out of ";
        ThresholdRangeCondition.Operator operatorLow = condition.getOperatorLow();
        ThresholdRangeCondition.Operator operatorHigh = condition.getOperatorHigh();
        description = operatorLow.equals((Object)ThresholdRangeCondition.Operator.INCLUSIVE) ? description + "[" : description + "(";
        description = description + this.decimalFormat.format(condition.getThresholdLow());
        description = description + ", ";
        description = description + this.decimalFormat.format(condition.getThresholdHigh());
        description = operatorHigh.equals((Object)ThresholdRangeCondition.Operator.INCLUSIVE) ? description + "]" : description + ")";
        description = condition.getContext() != null && condition.getContext().get(CONTEXT_PROPERTY_UNIT) != null ? description + " " + (String)condition.getContext().get(CONTEXT_PROPERTY_UNIT) : description + " (range)";
        return description;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    public Alert getAlert() {
        return this.alert;
    }

    public void setAlert(Alert alert) {
        this.alert = alert;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Trigger getTrigger() {
        return this.trigger;
    }

    public void setTrigger(Trigger trigger) {
        this.trigger = trigger;
    }

    public Dampening getDampening() {
        return this.dampening;
    }

    public void setDampening(Dampening dampening) {
        this.dampening = dampening;
    }

    public String getDampeningDescription() {
        return this.dampeningDescription;
    }

    public void setDampeningDescription(String dampeningDescription) {
        this.dampeningDescription = dampeningDescription;
    }

    public Map<String, String> getProps() {
        return this.props;
    }

    public void setProps(Map<String, String> props) {
        this.props = props;
    }

    public int getNumConditions() {
        return this.numConditions;
    }

    public void setNumConditions(int numConditions) {
        this.numConditions = numConditions;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public ConditionDescription[] getConditions() {
        return this.conditions;
    }

    public void setConditions(ConditionDescription[] conditions) {
        this.conditions = conditions;
    }

    public String getTriggerDescription() {
        return this.triggerDescription;
    }

    public void setTriggerDescription(String triggerDescription) {
        this.triggerDescription = triggerDescription;
    }

    public static class ConditionDescription {
        protected Condition condition;
        protected String description;
        protected List<Double> data = new ArrayList<Double>();
        protected Double average;
        protected String averageDescription;

        public Condition getCondition() {
            return this.condition;
        }

        public void setCondition(Condition condition) {
            this.condition = condition;
        }

        public String getDescription() {
            return this.description;
        }

        public void setDescription(String description) {
            this.description = description;
        }

        public List<Double> getData() {
            return this.data;
        }

        public void setData(List<Double> data) {
            this.data = data;
        }

        public Double getAverage() {
            return this.average;
        }

        public void setAverage(Double average) {
            this.average = average;
        }

        public String getAverageDescription() {
            return this.averageDescription;
        }

        public void setAverageDescription(String averageDescription) {
            this.averageDescription = averageDescription;
        }
    }
}

